/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.eclipse.core.runtime.ListenerList;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public abstract class LiveExpression<V> {
    private ListenerList fListeners = new ListenerList();
    protected V value;

    public LiveExpression(V initialValue) {
        this.value = initialValue;
    }

    public LiveExpression() {
    }

    public void refresh() {
        V newValue = this.compute();
        if (!LiveExpression.equals(newValue, this.value)) {
            this.value = newValue;
            this.changed();
        }
    }

    private static <V> boolean equals(V a, V b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public <O> LiveExpression<V> dependsOn(LiveExpression<O> other) {
        other.addListener(new ValueListener<O>(){

            @Override
            public void gotValue(LiveExpression<O> exp, O value) {
                LiveExpression.this.refresh();
            }
        });
        return this;
    }

    protected abstract V compute();

    protected void changed() {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object _l = objectArray[n2];
            ValueListener l = (ValueListener)_l;
            l.gotValue(this, this.value);
            ++n2;
        }
    }

    public V getValue() {
        return this.value;
    }

    public void addListener(ValueListener<V> l) {
        this.fListeners.add(l);
        l.gotValue(this, this.value);
    }

    public void removeListener(ValueListener<V> l) {
        this.fListeners.remove(l);
    }

    public static <V> LiveExpression<V> constant(V value) {
        return new LiveExpression<V>((Object)value){

            @Override
            protected V compute() {
                return this.value;
            }

            @Override
            public void addListener(ValueListener<V> l) {
                l.gotValue(this, this.value);
            }

            @Override
            public void removeListener(ValueListener<V> l) {
            }

            @Override
            public void refresh() {
            }
        };
    }
}

