/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

public class RetryUtil {
    public static <T> T retry(long interval, long timelimit, Callable<T> task) throws Exception {
        T result = null;
        boolean success = false;
        Throwable error = null;
        long endTime = System.currentTimeMillis() + timelimit;
        do {
            try {
                result = task.call();
                success = true;
            }
            catch (Throwable e) {
                error = e;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (!success && System.currentTimeMillis() < endTime);
        if (success) {
            return result;
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new InvocationTargetException(error);
    }
}

