/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomParser {
    private Document doc;
    private HashMap<String, String> properties = null;

    private void parse(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        this.doc = dBuilder.parse(input);
    }

    public PomParser(IFile pomFile) throws CoreException {
        this.parse(pomFile);
    }

    private void parse(IFile file) throws CoreException {
        InputStream input = null;
        try {
            try {
                input = file.getContents(true);
                this.parse(input);
            }
            catch (Exception e) {
                throw ExceptionUtil.coreException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream open(IFile file) throws CoreException {
        return file.getContents(true);
    }

    public String getProperty(String name) {
        Map<String, String> props = this.getProperties();
        return props.get(name);
    }

    private Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
            NodeList propLists = this.doc.getElementsByTagName("properties");
            int i = 0;
            while (i < propLists.getLength()) {
                Node propList = propLists.item(i);
                NodeList propNodes = propList.getChildNodes();
                int j = 0;
                while (j < propNodes.getLength()) {
                    Node propNode = propNodes.item(j);
                    String name = XmlUtils.getTagName((Node)propNode);
                    if (name != null) {
                        String value = propNode.getTextContent();
                        this.properties.put(name, value);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.properties;
    }
}

