/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.cli;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.IBootInstallFactory;
import org.springframework.ide.eclipse.boot.core.cli.LocalBootInstall;
import org.springframework.ide.eclipse.boot.core.cli.install.GenericBootInstall;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;
import org.springframework.ide.eclipse.boot.core.cli.install.ZippedBootInstall;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.util.ArrayEncoder;

public class BootInstallManager
implements IBootInstallFactory {
    private static final String BOOT_INSTALLS = "installs";
    private static final String DEFAULT_BOOT_INSTALL = "default.install";
    private static BootInstallManager instance;
    private DownloadManager downloader = new DownloadManager(null, BootInstallManager.determineCacheDir());
    private List<IBootInstall> installs = new ArrayList<IBootInstall>();
    private IBootInstall defaultInstall;

    private static File determineCacheDir() {
        IPath stateLocation = BootActivator.getDefault().getStateLocation();
        return stateLocation.append(BOOT_INSTALLS).toFile();
    }

    public static BootInstallManager getInstance() throws Exception {
        if (instance == null) {
            instance = new BootInstallManager();
        }
        return instance;
    }

    private BootInstallManager() throws Exception {
        this.read();
        if (this.installs.isEmpty()) {
            this.setDefaultInstall(this.newInstall(StsProperties.getInstance().get("spring.boot.install.url"), null));
        }
    }

    private void read() {
        IEclipsePreferences prefs = this.getPrefs();
        String defaultName = prefs.get(DEFAULT_BOOT_INSTALL, "");
        String encoded = prefs.get(BOOT_INSTALLS, null);
        if (encoded != null) {
            String[] encodedInstalls;
            String[] stringArray = encodedInstalls = ArrayEncoder.decode((String)encoded);
            int n = encodedInstalls.length;
            int n2 = 0;
            while (n2 < n) {
                String encodedInstall = stringArray[n2];
                try {
                    String[] parts = ArrayEncoder.decode((String)encodedInstall);
                    IBootInstall install = this.newInstall(parts[0], parts[1]);
                    this.installs.add(install);
                    if (defaultName.equals(install.getName())) {
                        this.setDefaultInstall(install);
                    }
                }
                catch (Exception e) {
                    BootActivator.log(e);
                }
                ++n2;
            }
        }
    }

    protected IEclipsePreferences getPrefs() {
        return InstanceScope.INSTANCE.getNode("org.springframework.ide.eclipse.boot");
    }

    public void save() {
        List<IBootInstall> local = this.installs;
        String[] encodedInstalls = new String[local.size()];
        int i = 0;
        while (i < encodedInstalls.length) {
            encodedInstalls[i] = this.encodeInstall(local.get(i));
            ++i;
        }
        String encoded = ArrayEncoder.encode((String[])encodedInstalls);
        IEclipsePreferences prefs = this.getPrefs();
        prefs.put(BOOT_INSTALLS, encoded);
        IBootInstall di = null;
        try {
            di = this.getDefaultInstall();
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        if (di == null) {
            prefs.remove(DEFAULT_BOOT_INSTALL);
        } else {
            prefs.put(DEFAULT_BOOT_INSTALL, di.getName());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            BootActivator.log(e);
        }
    }

    private String encodeInstall(IBootInstall install) {
        return ArrayEncoder.encode((String[])new String[]{install.getUrl(), install.getName()});
    }

    @Override
    public IBootInstall newInstall(String url, String name) {
        try {
            URI uri = new URI(url);
            if ("file".equals(uri.getScheme())) {
                File file = new File(uri);
                if (file.isDirectory()) {
                    return new LocalBootInstall(file, name);
                }
                return new ZippedBootInstall(this.downloader, url, name);
            }
            String path = uri.getPath();
            if (path.toLowerCase().endsWith(".zip")) {
                return new ZippedBootInstall(this.downloader, url, name);
            }
            return new GenericBootInstall(url, null, "Not a zip url: " + url);
        }
        catch (Exception e) {
            BootActivator.log(e);
            return new GenericBootInstall(url, name, ExceptionUtil.getMessage((Throwable)e));
        }
    }

    public synchronized IBootInstall getDefaultInstall() throws Exception {
        return this.defaultInstall;
    }

    public void setDefaultInstall(IBootInstall defaultInstall) {
        if (!this.installs.contains(defaultInstall)) {
            this.installs.add(defaultInstall);
        }
        this.defaultInstall = defaultInstall;
    }

    public void setInstalls(Collection<IBootInstall> newInstalls) {
        this.installs = new ArrayList<IBootInstall>(newInstalls);
    }

    public Collection<IBootInstall> getInstalls() {
        return new ArrayList<IBootInstall>(this.installs);
    }
}

