/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.cli;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.BootInstallManager;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;

public class BootGroovyScriptLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ID = "org.springsource.ide.eclipse.boot.groovy.script.launch";
    private static final String SCRIPT_RSRC = "spring.groovy.script.rsrc";

    public static void setScript(ILaunchConfigurationWorkingCopy wc, IFile rsrc) {
        wc.setAttribute(SCRIPT_RSRC, rsrc.getFullPath().toString());
    }

    public static IFile getScript(ILaunchConfiguration conf) throws CoreException {
        String fullPathStr = conf.getAttribute(SCRIPT_RSRC, null);
        if (fullPathStr != null) {
            Path fullPath = new Path(fullPathStr);
            Assert.isLegal((fullPath.segmentCount() >= 2 ? 1 : 0) != 0);
            String projectName = fullPath.segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return project.getFile(fullPath.removeFirstSegments(1));
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration conf) throws CoreException {
        String fullPathStr = conf.getAttribute(SCRIPT_RSRC, null);
        if (fullPathStr != null) {
            Path fullPath = new Path(fullPathStr);
            return fullPath.segment(0);
        }
        return null;
    }

    public static IProject getProject(ILaunchConfiguration conf) throws CoreException {
        String name = BootGroovyScriptLaunchConfigurationDelegate.getProjectName(conf);
        if (name != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return null;
    }

    public static File getSpringBootHome(ILaunchConfiguration conf) throws Exception {
        return BootGroovyScriptLaunchConfigurationDelegate.getSpringBootInstall().getHome();
    }

    public static IBootInstall getSpringBootInstall() throws Exception {
        return BootInstallManager.getInstance().getDefaultInstall();
    }

    public static String[] getSpringBootClasspath(ILaunchConfiguration conf) throws Exception {
        File[] libjars = BootGroovyScriptLaunchConfigurationDelegate.getSpringBootInstall().getBootLibJars();
        ArrayList<String> classpath = new ArrayList<String>(libjars.length + 1);
        classpath.add(".");
        File[] fileArray = libjars;
        int n = libjars.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            classpath.add(jarFile.toString());
            ++n2;
        }
        return classpath.toArray(new String[classpath.size()]);
    }

    protected String getMainTypeName(ILaunchConfiguration conf) {
        return "org.springframework.boot.loader.JarLauncher";
    }

    protected void checkCancelled(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IFile scriptFile = BootGroovyScriptLaunchConfigurationDelegate.getScript(conf);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
            this.checkCancelled((IProgressMonitor)subMonitor);
            subMonitor.beginTask("Starting Spring Script: " + scriptFile.getName(), 5);
            subMonitor.worked(1);
            this.checkCancelled((IProgressMonitor)subMonitor);
            subMonitor.subTask("Configuring launch parameters...");
            IVMInstall vm = this.verifyVMInstall(conf);
            IVMRunner runner = vm.getVMRunner(mode);
            String mainTypeName = this.getMainTypeName(conf);
            IProject project = BootGroovyScriptLaunchConfigurationDelegate.getProject(conf);
            String[] classpath = BootGroovyScriptLaunchConfigurationDelegate.getSpringBootClasspath(conf);
            File springBootHome = BootGroovyScriptLaunchConfigurationDelegate.getSpringBootHome(conf);
            System.out.println("Spring Boot Home = " + springBootHome);
            ArrayList<String> programArgs = new ArrayList<String>();
            programArgs.add("run");
            programArgs.add(scriptFile.getProjectRelativePath().toString());
            VMRunnerConfiguration runConfiguration = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfiguration.setProgramArguments(programArgs.toArray(new String[programArgs.size()]));
            runConfiguration.setWorkingDirectory(project.getLocation().toFile().toString());
            runner.run(runConfiguration, launch, monitor);
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
    }

    protected IVMInstall verifyVMInstall(ILaunchConfiguration conf) {
        return JavaRuntime.getDefaultVMInstall();
    }
}

