/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.completions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.completions.DirectedGraph;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.ui.ChooseDependencyDialog;
import org.springframework.ide.eclipse.boot.util.RetryUtil;
import org.springsource.ide.eclipse.commons.completions.externaltype.AbstractExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscovery;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeEntry;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.util.Requestor;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpringBootTypeDiscovery
implements ExternalTypeDiscovery {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static StsProperties stsProps = StsProperties.getInstance();
    private static final long RETRY_INTERVAL = 15000L;
    private static final long RETRY_TIMELIMIT = 300000L;
    private static final boolean DEBUG = false;
    private boolean preferManagedVersion = true;
    private boolean transitive = false;
    private String bootVersion;
    private static URI XML_DATA_LOCATION;

    static {
        try {
            XML_DATA_LOCATION = new URI(stsProps.get("spring.boot.typegraph.url"));
        }
        catch (URISyntaxException e) {
            BootActivator.log(e);
        }
    }

    public SpringBootTypeDiscovery(String bootVersion) {
        Assert.isNotNull((Object)bootVersion);
        this.bootVersion = bootVersion;
    }

    public void getTypes(Requestor<ExternalTypeEntry> requestor) {
        try {
            DirectedGraph dgraph = this.createGraph();
            Set nodes = dgraph.getNonLeafNodes();
            for (Object node : nodes) {
                if (!(node instanceof ExternalType)) continue;
                ExternalType type = (ExternalType)node;
                requestor.receive((Object)new ExternalTypeEntry(type, (ExternalTypeSource)new DGraphTypeSource(dgraph, type)));
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
    }

    private DirectedGraph createGraph() throws Exception {
        return RetryUtil.retry(15000L, 300000L, new Callable<DirectedGraph>(){

            @Override
            public DirectedGraph call() throws Exception {
                DirectedGraph dgraph = new DirectedGraph();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                MyHandler handler = new MyHandler(dgraph);
                try {
                    saxParser.parse(String.valueOf(XML_DATA_LOCATION.toString()) + "/" + SpringBootTypeDiscovery.this.bootVersion, (DefaultHandler)handler);
                }
                finally {
                    handler.dispose();
                }
                return dgraph;
            }
        });
    }

    private DirectedGraph createGraphMaybe() throws Exception {
        DirectedGraph dgraph = new DirectedGraph();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        MyHandler handler = new MyHandler(dgraph);
        try {
            saxParser.parse(XML_DATA_LOCATION.toString(), (DefaultHandler)handler);
        }
        finally {
            handler.dispose();
        }
        return dgraph;
    }

    public class DGraphTypeSource
    extends AbstractExternalTypeSource {
        private DirectedGraph dgraph;
        private ExternalType type;

        public DGraphTypeSource(DirectedGraph dgraph, ExternalType type) {
            this.dgraph = dgraph;
            this.type = type;
        }

        public void addToClassPath(IJavaProject project, IProgressMonitor mon) {
            try {
                ISpringBootProject bootProject = SpringBootCore.create(project);
                Collection<MavenCoordinates> sources = this.getProviders();
                MavenCoordinates source = this.chooseSource(sources);
                if (source != null) {
                    bootProject.addMavenDependency(source, SpringBootTypeDiscovery.this.preferManagedVersion);
                }
            }
            catch (Exception e) {
                BootActivator.log(e);
            }
        }

        public Collection<MavenCoordinates> getProviders() {
            Collection sources = SpringBootTypeDiscovery.this.transitive ? this.dgraph.getDescendants(this.type) : this.dgraph.getSuccessors(this.type);
            return sources;
        }

        private MavenCoordinates chooseSource(Collection<MavenCoordinates> sources) {
            if (sources != null) {
                if (sources.size() == 1) {
                    Iterator<MavenCoordinates> iterator = sources.iterator();
                    if (iterator.hasNext()) {
                        MavenCoordinates mavenCoordinates = iterator.next();
                        return mavenCoordinates;
                    }
                } else if (sources.isEmpty()) {
                    return null;
                }
                return ChooseDependencyDialog.openOn("Choose a Dependency", "How do you want to add <b>" + this.type.getName() + "</b> from <b>" + this.type.getPackage() + "</b> to your classpath?", sources);
            }
            return null;
        }

        public String getDescription() {
            Collection<MavenCoordinates> ancestors = this.getProviders();
            if (!ancestors.isEmpty()) {
                StringBuilder description = new StringBuilder();
                description.append("Add type <b>" + this.type.getName() + "</b> from<br>" + "package <b>" + this.type.getPackage() + "</b><br>" + "to the classpath via one of the following:<p>");
                description.append("<ul>");
                for (MavenCoordinates object : ancestors) {
                    description.append(this.toHtml(object));
                }
                description.append("</ul>");
                return description.toString();
            }
            return null;
        }

        private String toHtml(Object object) {
            if (object instanceof MavenCoordinates) {
                MavenCoordinates artifact = (MavenCoordinates)object;
                StringBuilder html = new StringBuilder();
                html.append("<li>");
                html.append("<b>" + artifact.getArtifactId() + "</b><br>");
                html.append("group: " + artifact.getGroupId() + "<br>");
                html.append("version: " + artifact.getVersion());
                html.append("</li>");
                return html.toString();
            }
            return object.toString();
        }
    }

    private static class MyHandler
    extends DefaultHandler {
        Stack<Object> path = new Stack();
        private HashMap<String, String> strings = new HashMap();
        private DirectedGraph dgraph;

        public MyHandler(DirectedGraph dgraph) {
            this.dgraph = dgraph;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object parentElement = this.peek();
            MavenCoordinates thisElement = null;
            if (qName.equals("artifact")) {
                MavenCoordinates artifact = this.MavenCoordinates_parse(attributes.getValue("id"));
                if (artifact != null) {
                    thisElement = artifact;
                    if (parentElement != null) {
                        Assert.isLegal((boolean)(parentElement instanceof MavenCoordinates), (String)"parent of artifact should always be another artififact");
                        this.dgraph.addEdge(thisElement, parentElement);
                    }
                }
            } else if (qName.equals("type")) {
                ExternalType type = this.ExternalType_parse(attributes.getValue("id"));
                thisElement = type;
                Assert.isLegal((boolean)(parentElement instanceof MavenCoordinates), (String)("parent of a type should be an artifact (that contains it) but it was: " + parentElement));
                this.dgraph.addEdge(thisElement, parentElement);
            }
            this.path.push(thisElement);
        }

        private ExternalType ExternalType_parse(String fqName) {
            int split = fqName.lastIndexOf(46);
            if (split > 0) {
                String name = fqName.substring(split + 1);
                String packageName = fqName.substring(0, split);
                return new ExternalType(this.intern(name), this.intern(packageName));
            }
            throw new IllegalArgumentException("Invalid fqName: " + fqName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.path.pop();
        }

        private Object peek() {
            if (this.path.isEmpty()) {
                return null;
            }
            return this.path.peek();
        }

        public void dispose() {
            Assert.isLegal((boolean)this.path.isEmpty(), (String)"Bug: pops and pushes are out of whack!");
            this.strings = null;
        }

        public MavenCoordinates MavenCoordinates_parse(String artifact) {
            String type;
            String[] pieces = artifact.split(":");
            if (pieces.length == 3) {
                return new MavenCoordinates(this.intern(pieces[0]), this.intern(pieces[1]), this.intern(pieces[2]));
            }
            if (pieces.length == 4 && "jar".equals(type = pieces[2])) {
                return new MavenCoordinates(this.intern(pieces[0]), this.intern(pieces[1]), this.intern(pieces[3]));
            }
            throw new IllegalArgumentException("Unsupported artifact string: '" + artifact + "'");
        }

        private String intern(String string) {
            String existing = this.strings.get(string);
            if (existing == null) {
                this.strings.put(string, string);
                existing = string;
            }
            return existing;
        }
    }
}

