/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceModel;
import org.springframework.ide.eclipse.aop.core.model.IAopReferenceModel;
import org.springframework.ide.eclipse.core.MessageUtils;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.aop.core";
    public static final String PERSIST_AOP_MODEL_PREFERENCE = "org.springframework.ide.eclipse.aop.core.persistModel";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.aop.core.messages";
    private static Activator plugin;
    private static AopReferenceModel model;
    private ResourceBundle resourceBundle;

    public Activator() {
        plugin = this;
        model = new AopReferenceModel();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.getPreferenceStore().setDefault(PERSIST_AOP_MODEL_PREFERENCE, true);
        Job modelJob = new Job("Initializing Spring Aop Model"){

            protected IStatus run(IProgressMonitor monitor) {
                model.start();
                return Status.OK_STATUS;
            }
        };
        modelJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        modelJob.setSystem(true);
        modelJob.setPriority(10);
        modelJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        model.shutdown();
        plugin = null;
        this.resourceBundle = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static IAopReferenceModel getModel() {
        return model;
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = Activator.createErrorStatus(message, exception);
        Activator.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        Activator.getDefault().getLog().log(Activator.createErrorStatus("Internal Error", exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, Object ... args) {
        return MessageUtils.format((String)Activator.getResourceString(key), (Object[])args);
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = Activator.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                Activator.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public final ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

