/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.GraphBackgroundTask;
import org.tigris.subversion.subclipse.graph.editors.RevisionEditPart;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RefreshNodeAction
extends Action {
    private List selectedRevisions;
    private RevisionGraphEditor editor;

    public RefreshNodeAction(List selectedRevisions, RevisionGraphEditor editor) {
        this.editor = editor;
        this.selectedRevisions = selectedRevisions;
        this.setText(Policy.bind((String)"RefreshNodeAction.title"));
    }

    public void run() {
        IResource resource = ((RevisionGraphEditorInput)this.editor.getEditorInput()).getResource();
        ISVNRemoteResource remoteResource = ((RevisionGraphEditorInput)this.editor.getEditorInput()).getRemoteResource();
        GraphBackgroundTask task = resource == null ? new GraphBackgroundTask(SVNUIPlugin.getActivePage().getActivePart(), this.editor.getViewer(), this.editor, remoteResource) : new GraphBackgroundTask(SVNUIPlugin.getActivePage().getActivePart(), this.editor.getViewer(), this.editor, resource);
        task.setGetNewRevisions(false);
        SVNRevision[] revisions = new SVNRevision[this.selectedRevisions.size()];
        Node[] nodes = new Node[this.selectedRevisions.size()];
        int i = 0;
        while (i < this.selectedRevisions.size()) {
            nodes[i] = (Node)((RevisionEditPart)((Object)this.selectedRevisions.get(i))).getModel();
            revisions[i] = new SVNRevision.Number(nodes[i].getRevision());
            ++i;
        }
        task.setRefreshRevisions(revisions, nodes);
        try {
            task.run();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"RefreshNodeAction.title"), (String)e.getMessage());
        }
    }
}

