/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateMethodMarkerResolution
implements IMarkerResolution2 {
    private static final String MESSAGE_ATTRIBUTE_KEY = "message";
    private String markerMessage = "";

    public AbstractCreateMethodMarkerResolution(IMarker marker) {
        this.markerMessage = marker.getAttribute(MESSAGE_ATTRIBUTE_KEY, "");
    }

    protected String extractQuotedString(String startTag, String message) {
        int startPos = message.indexOf(startTag) + startTag.length();
        int endPos = message.indexOf("'", startPos);
        return message.substring(startPos, endPos);
    }

    protected List<Expression> getArguments(Expression invocationExpression) {
        MethodInvocation methodInvocation = (MethodInvocation)invocationExpression;
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argumentExpression : methodInvocation.arguments()) {
            arguments.add(argumentExpression);
        }
        return arguments;
    }

    public abstract String getDescription();

    public Image getImage() {
        return null;
    }

    public abstract String getLabel();

    protected String getMarkerMessage() {
        return this.markerMessage;
    }

    protected Expression getMockMethodInvocation() {
        ASTParser fooParser = ASTParser.newParser((int)3);
        fooParser.setKind(2);
        String mockMethodInvocationCode = String.valueOf(this.getNewMethodName()) + "(" + this.getNewMethodParameters() + ");";
        fooParser.setSource(mockMethodInvocationCode.toCharArray());
        fooParser.setResolveBindings(true);
        ASTNode parsedAstNode = fooParser.createAST(null);
        Block codeBlock = (Block)parsedAstNode;
        ExpressionStatement methodInvocationExpressionStatement = (ExpressionStatement)codeBlock.statements().get(0);
        return methodInvocationExpressionStatement.getExpression();
    }

    protected abstract String getNewMethodName();

    protected String getNewMethodParameters() {
        return "";
    }

    protected abstract String getTargetClass();

    protected ITypeBinding getTargetTypeBinding(IJavaProject javaProject, IType targetType) {
        ASTParser bindingParser = ASTParser.newParser((int)3);
        bindingParser.setKind(8);
        bindingParser.setSource(targetType.getCompilationUnit());
        bindingParser.setResolveBindings(true);
        bindingParser.setProject(javaProject);
        IBinding[] bindings = bindingParser.createBindings(new IJavaElement[]{targetType}, (IProgressMonitor)new NullProgressMonitor());
        ITypeBinding typeBinding = (ITypeBinding)bindings[0];
        return typeBinding;
    }

    public void run(IMarker marker) {
        ICompletionProposal newMethodCompletionProposal;
        IProject project = marker.getResource().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType targetType = null;
        try {
            targetType = javaProject.findType(this.getTargetClass());
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Fix Error", (String)("Could not find class '" + this.getTargetClass() + "'"));
            return;
        }
        if (targetType == null) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.bestpractices", "Could not find class '" + this.getTargetClass() + "'"));
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Fix Error", (String)("Could not find class '" + this.getTargetClass() + "'"));
            return;
        }
        Expression mockMethodInvocation = this.getMockMethodInvocation();
        ITypeBinding typeBinding = this.getTargetTypeBinding(javaProject, targetType);
        List<Expression> arguments = this.getArguments(mockMethodInvocation);
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif");
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.NewMethodCompletionProposal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposal");
            }
            Constructor<?> constructor = clazz.getConstructor(String.class, ICompilationUnit.class, ASTNode.class, List.class, ITypeBinding.class, Integer.TYPE, Image.class);
            newMethodCompletionProposal = (ICompletionProposal)constructor.newInstance("Add missing property", targetType.getCompilationUnit(), mockMethodInvocation, arguments, typeBinding, 0, image);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.bestpractices", "Problems occured when creating completion proposal", t));
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Fix Error", (String)"Could not execute correction proposal");
            return;
        }
        IStructuredModel model = null;
        try {
            try {
                model = XmlQuickFixUtil.getModel(marker);
                newMethodCompletionProposal.apply((IDocument)model.getStructuredDocument());
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)e.getStatus());
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Fix Error", (String)"Could not find error marker");
                if (model != null) {
                    model.releaseFromEdit();
                    model = null;
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
                model = null;
            }
        }
    }
}

