/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.navigator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ILinkHelper;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;
import org.springframework.ide.eclipse.ui.dialogs.WrappingStructuredSelection;
import org.springframework.ide.eclipse.ui.navigator.actions.ILinkHelperExtension;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class SpringNavigator
extends CommonNavigator
implements ISelectionListener {
    private static Map<Object, Object> workingCopyManagersForEditors = new HashMap<Object, Object>();
    private ISelection lastElement;
    private Object linkService;
    private IPropertyListener propertyListener;
    private Method linkServiceMethod;

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.propertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 65536) {
                    SpringNavigator.this.updateTreeViewer((IWorkbenchPart)SpringNavigator.this, SpringNavigator.this.lastElement, false);
                }
            }
        };
        this.addPropertyListener(this.propertyListener);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.removePropertyListener(this.propertyListener);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            selection = new WrappingStructuredSelection((IStructuredSelection)selection);
        }
        this.updateTreeViewer(part, (ISelection)selection, true);
    }

    private ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(editor, caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    private void determineAndRefreshViewer(IWorkbenchPart part, ISelection selection, boolean ignoreSameSelection) {
        Object element = this.getSelectedElement(part, selection);
        if (element == null || element.equals(this.lastElement) && ignoreSameSelection) {
            return;
        }
        if ((element instanceof IType || element instanceof IMethod || element instanceof IField || element instanceof Element || element instanceof IResource) && this.isLinkingEnabled()) {
            this.selectReveal((TreeViewer)this.getCommonViewer(), element);
        }
        this.lastElement = selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block20: {
            void var4_6;
            if (workingCopyManagersForEditors.get(editor) instanceof IWorkingCopyManager) {
                IWorkingCopyManager iWorkingCopyManager = (IWorkingCopyManager)workingCopyManagersForEditors.get(editor);
            } else {
                WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
            }
            ICompilationUnit unit = var4_6.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        IJavaElement[] children;
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IJavaElement[] iJavaElementArray = children = unit.getChildren();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IJavaElement element = iJavaElementArray[n2];
                            if (element instanceof SourceType) {
                                return element;
                            }
                            ++n2;
                        }
                        break block20;
                    }
                    if (unit.isConsistent()) {
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IResource res = unit.getCorrespondingResource();
                        if (res instanceof IFile) {
                            IMarker[] javaModelMarkers;
                            IFile file = (IFile)res;
                            IProject containingProject = file.getProject();
                            IMarker[] iMarkerArray = javaModelMarkers = containingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                            int n = javaModelMarkers.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IMarker marker = iMarkerArray[n3];
                                if (marker.getResource().equals((Object)file)) {
                                    return null;
                                }
                                ++n3;
                            }
                        }
                        if (elementAt == null && unit.getChildren().length != 0) {
                            return unit.getChildren()[0];
                        }
                    }
                }
                catch (JavaModelException x) {
                    if (!x.isDoesNotExist()) {
                        JavaPlugin.log((IStatus)x.getStatus());
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    private synchronized Object getInternalLinkHelperService() {
        if (this.linkService == null) {
            try {
                try {
                    Method method = CommonNavigator.class.getDeclaredMethod("getLinkHelperService", new Class[0]);
                    method.setAccessible(true);
                    this.linkService = method.invoke((Object)this, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Class<?> clazz = Class.forName("org.eclipse.ui.internal.navigator.extensions.LinkHelperService");
                    Constructor<?> constructor = clazz.getConstructor(NavigatorContentService.class);
                    this.linkService = constructor.newInstance((NavigatorContentService)this.getCommonViewer().getNavigatorContentService());
                }
                this.linkServiceMethod = this.linkService.getClass().getDeclaredMethod("getLinkHelpersFor", Object.class);
            }
            catch (Throwable e) {
                SpringUIPlugin.log(e);
            }
        }
        return this.linkService;
    }

    private ILinkHelper[] getInternalLinkHelpersFor(Object object) {
        if (this.getInternalLinkHelperService() != null && this.linkServiceMethod != null) {
            try {
                return (ILinkHelper[])this.linkServiceMethod.invoke(this.getInternalLinkHelperService(), object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return new ILinkHelper[0];
    }

    private Object getSelectedElement(IWorkbenchPart part, ISelection selection) {
        Object selectedElement = this.getSelectedJavaElement(part, selection);
        if (selectedElement == null) {
            selectedElement = this.getSelectedXmlElement(selection);
        }
        return selectedElement;
    }

    private IJavaElement getSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement && !(first instanceof IJavaProject)) {
                return (IJavaElement)first;
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = this.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return javaElement;
        }
        return null;
    }

    private Object getSelectedXmlElement(ISelection selection) {
        Object selectedElement = null;
        if (selection instanceof IStructuredSelection) {
            Node parent;
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            Object obj = structSelection.getFirstElement();
            if (obj instanceof Element) {
                selectedElement = obj;
            } else if (obj instanceof Text) {
                Node parent2 = ((Text)obj).getParentNode();
                if (parent2 instanceof Element) {
                    selectedElement = parent2;
                }
            } else if (obj instanceof Comment && (parent = ((Comment)obj).getParentNode()) instanceof Element) {
                selectedElement = parent;
            }
        }
        return selectedElement;
    }

    private void selectReveal(TreeViewer viewer, Object element) {
        ILinkHelper[] helpers;
        ILinkHelper[] iLinkHelperArray = helpers = this.getInternalLinkHelpersFor(element);
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredSelection selection;
            ILinkHelper helper = iLinkHelperArray[n2];
            if (helper instanceof ILinkHelperExtension && (selection = ((ILinkHelperExtension)helper).findSelection(element)) != null) {
                viewer.getTree().setRedraw(false);
                super.selectReveal((ISelection)selection);
                viewer.getTree().setRedraw(true);
                break;
            }
            ++n2;
        }
    }

    private void updateTreeViewer(final IWorkbenchPart part, final ISelection selection, final boolean ignoreSameSelection) {
        Control ctrl = this.getCommonViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.determineAndRefreshViewer(part, selection, ignoreSameSelection);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control ctrl = SpringNavigator.this.getCommonViewer().getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    SpringNavigator.this.determineAndRefreshViewer(part, selection, ignoreSameSelection);
                }
            });
        }
    }
}

