/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.dialogs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleConfigurationDialog
extends TrayDialog {
    private final Map<String, String> propertyValues;
    private final Map<String, Integer> messageSeverities;
    private final String ruleName;
    private final ValidationRuleDefinition validationRule;
    private Label errorLabel;
    private Button okButton;
    private Set<PropertyModifyListener> propertyModifyListeners = new HashSet<PropertyModifyListener>();
    private Set<SeverityModifyListener> severityModifyListeners = new HashSet<SeverityModifyListener>();

    public ValidationRuleConfigurationDialog(Shell parentShell, Map<String, String> propertyValues, Map<String, Integer> messageSeverities, ValidationRuleDefinition ruleDefinition) {
        super(parentShell);
        this.validationRule = ruleDefinition;
        this.propertyValues = propertyValues;
        this.messageSeverities = messageSeverities;
        this.ruleName = ruleDefinition.getName();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Configure rule '" + this.ruleName + "'");
    }

    protected Control createDialogArea(Composite parent) {
        Combo text;
        Point size;
        Label label;
        GridData labelData;
        GridData textData;
        Group group;
        GridLayout layout;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        if (this.propertyValues.size() > 0) {
            layout = new GridLayout();
            layout.numColumns = 1;
            group = new Group(parentComposite, 0);
            group.setText("Properties");
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(1808));
            Composite composite = new Composite((Composite)group, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)layout);
            textData = new GridData(768);
            textData.widthHint = 450;
            for (Map.Entry<String, Object> entry : this.propertyValues.entrySet()) {
                labelData = new GridData();
                labelData = new GridData(768);
                label = new Label(composite, 0);
                label.setText(String.valueOf(this.validationRule.getPropertyDescription(entry.getKey())) + ":");
                size = label.computeSize(-1, -1);
                labelData.widthHint = size.x;
                label.setLayoutData((Object)labelData);
                text = new Text(composite, 2052);
                text.setText((String)entry.getValue());
                text.setLayoutData((Object)textData);
                PropertyModifyListener listener = new PropertyModifyListener((Text)text, entry.getKey(), this.validationRule.getRule().getClass());
                text.addModifyListener((ModifyListener)listener);
                this.propertyModifyListeners.add(listener);
            }
        }
        if (this.messageSeverities.size() > 0) {
            layout = new GridLayout();
            layout.numColumns = 2;
            group = new Group(parentComposite, 0);
            group.setText("Severities");
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(1808));
            Composite severityComposite = new Composite((Composite)group, 0);
            severityComposite.setLayout((Layout)layout);
            textData = new GridData(768);
            for (Map.Entry<String, Object> entry : this.messageSeverities.entrySet()) {
                labelData = new GridData();
                labelData = new GridData(768);
                label = new Label(severityComposite, 0);
                label.setText(String.valueOf(this.validationRule.getMessageLabel(entry.getKey())) + ":");
                size = label.computeSize(-1, -1);
                labelData.widthHint = size.x;
                label.setLayoutData((Object)labelData);
                text = new Combo(severityComposite, 2060);
                text.setItems(new String[]{"Error", "Warning", "Info", "Ignore"});
                int severity = (Integer)entry.getValue();
                switch (severity) {
                    case 2: {
                        text.select(0);
                        break;
                    }
                    case 1: {
                        text.select(1);
                        break;
                    }
                    case 0: {
                        text.select(2);
                        break;
                    }
                    default: {
                        text.select(3);
                    }
                }
                text.setLayoutData((Object)textData);
                SeverityModifyListener listener = new SeverityModifyListener(text, entry.getKey());
                text.addModifyListener((ModifyListener)listener);
                this.severityModifyListeners.add(listener);
            }
        }
        this.errorLabel = new Label(parentComposite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setForeground(JFaceColors.getErrorText((Display)parent.getDisplay()));
        this.errorLabel.setBackground(JFaceColors.getErrorBackground((Display)parent.getDisplay()));
        ValidationRuleConfigurationDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            for (PropertyModifyListener propertyModifyListener : this.propertyModifyListeners) {
                this.propertyValues.put(propertyModifyListener.getName(), propertyModifyListener.getValue());
            }
            for (SeverityModifyListener severityModifyListener : this.severityModifyListeners) {
                this.messageSeverities.put(severityModifyListener.getName(), severityModifyListener.getValue());
            }
        }
        super.buttonPressed(buttonId);
    }

    private void setErrorLabel(String error) {
        this.errorLabel.setText(error);
        this.okButton.setEnabled(!StringUtils.hasText((String)error));
    }

    private class PropertyModifyListener
    implements ModifyListener {
        private final Text text;
        private final String name;
        private final BeanWrapper wrapper;

        public PropertyModifyListener(Text text, String name, Class ruleClass) {
            this.wrapper = new BeanWrapperImpl(ruleClass);
            this.text = text;
            this.name = name;
        }

        public void modifyText(ModifyEvent e) {
            String value = this.getValue();
            try {
                this.wrapper.setPropertyValue(this.name, (Object)value);
                ValidationRuleConfigurationDialog.this.setErrorLabel("");
            }
            catch (BeansException beansException) {
                ValidationRuleConfigurationDialog.this.setErrorLabel("Value '" + value + "' is not valid for property '" + this.name + "'");
            }
        }

        public String getValue() {
            return this.text.getText();
        }

        public String getName() {
            return this.name;
        }
    }

    private class SeverityModifyListener
    implements ModifyListener {
        private final Combo text;
        private final String name;

        public SeverityModifyListener(Combo text, String name) {
            this.text = text;
            this.name = name;
        }

        public Integer getValue() {
            String severity = this.text.getText();
            if ("Error".equals(severity)) {
                return 2;
            }
            if ("Warning".equals(severity)) {
                return 1;
            }
            if ("Info".equals(severity)) {
                return 0;
            }
            return -1;
        }

        public String getName() {
            return this.name;
        }

        public void modifyText(ModifyEvent e) {
        }
    }
}

