/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.properties.filter.IFilterEditor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFilterEditor
implements IFilterEditor {
    private CheckedTreeSelectionDialog mDialog;
    private IProject mInputProject;
    private List<String> mFilterData;

    @Override
    public int openEditor(Shell parent) {
        this.mDialog = new CheckedTreeSelectionDialog(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), new SourceFolderContentProvider());
        this.initCheckedTreeSelectionDialog();
        int retCode = this.mDialog.open();
        if (retCode == 0) {
            this.mFilterData = this.getFilterDataFromDialog();
            if (!this.mDialog.isRecursivlyExcludeSubTree()) {
                this.mFilterData.add("<recurse=false>");
            }
        }
        return retCode;
    }

    @Override
    public void setInputProject(IProject input) {
        this.mInputProject = input;
    }

    @Override
    public void setFilterData(List<String> filterData) {
        this.mFilterData = filterData;
    }

    @Override
    public List<String> getFilterData() {
        return this.mFilterData;
    }

    private void initCheckedTreeSelectionDialog() {
        this.mDialog.setTitle(Messages.PackageFilterEditor_titleFilterPackages);
        this.mDialog.setMessage(Messages.PackageFilterEditor_msgFilterPackages);
        this.mDialog.setBlockOnOpen(true);
        this.mDialog.setInput(this.mInputProject);
        if (this.mInputProject != null && this.mFilterData != null) {
            ArrayList<IResource> selectedElements = new ArrayList<IResource>();
            ArrayList<IResource> expandedElements = new ArrayList<IResource>();
            boolean recurse = true;
            int size = this.mFilterData != null ? this.mFilterData.size() : 0;
            int i = 0;
            while (i < size) {
                String el = this.mFilterData.get(i);
                if ("<recurse=false>".equals(el)) {
                    recurse = false;
                } else {
                    Path path = new Path(el);
                    IResource selElement = this.mInputProject.findMember((IPath)path);
                    if (selElement != null) {
                        selectedElements.add(selElement);
                    }
                    while (path.segmentCount() > 0) {
                        IResource expElement = this.mInputProject.findMember((IPath)(path = path.removeLastSegments(1)));
                        if (expElement == null) continue;
                        expandedElements.add(expElement);
                    }
                }
                ++i;
            }
            this.mDialog.setInitialSelections(selectedElements.toArray());
            this.mDialog.setExpandedElements(expandedElements.toArray());
            this.mDialog.setRecursivlyExcludeSubTree(recurse);
        }
    }

    private List<String> getFilterDataFromDialog() {
        Object[] checked = this.mDialog.getResult();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IResource) {
                result.add(((IResource)checked[i]).getProjectRelativePath().toString());
            }
            ++i;
        }
        return result;
    }

    public class CheckedTreeSelectionDialog
    extends SelectionStatusDialog {
        private CheckboxTreeViewer fViewer;
        private final ILabelProvider fLabelProvider;
        private final ITreeContentProvider fContentProvider;
        private Button mBtnRecurseSubPackages;
        private Object fInput;
        private boolean fIsEmpty;
        private int fWidth;
        private int fHeight;
        private Object[] fExpandedElements;
        private boolean mRecursivlyExcludeSubPackages;

        public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent);
            this.fWidth = 60;
            this.fHeight = 18;
            this.mRecursivlyExcludeSubPackages = true;
            this.fLabelProvider = labelProvider;
            this.fContentProvider = contentProvider;
            this.setResult(new ArrayList(0));
            this.setStatusLineAboveButtons(true);
            this.fExpandedElements = null;
            int shellStyle = this.getShellStyle();
            this.setShellStyle(shellStyle | 0x400 | 0x10);
        }

        public void setInitialSelection(Object selection) {
            this.setInitialSelections(new Object[]{selection});
        }

        public void setInput(Object input) {
            this.fInput = input;
        }

        public void setExpandedElements(Object[] elements) {
            this.fExpandedElements = elements;
        }

        public void setSize(int width, int height) {
            this.fWidth = width;
            this.fHeight = height;
        }

        public void setRecursivlyExcludeSubTree(boolean recursivlyExcludeSubTree) {
            this.mRecursivlyExcludeSubPackages = recursivlyExcludeSubTree;
        }

        protected boolean isRecursivlyExcludeSubTree() {
            return this.mRecursivlyExcludeSubPackages;
        }

        public int open() {
            this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
            super.open();
            return this.getReturnCode();
        }

        protected void cancelPressed() {
            this.setResult(null);
            super.cancelPressed();
        }

        protected void computeResult() {
            List<Object> checked = Arrays.asList(this.fViewer.getCheckedElements());
            if (!this.mRecursivlyExcludeSubPackages) {
                this.setResult(checked);
            } else {
                List<Object> grayed = Arrays.asList(this.fViewer.getGrayedElements());
                ArrayList<Object> pureChecked = new ArrayList<Object>(checked);
                pureChecked.removeAll(grayed);
                this.setResult(pureChecked);
            }
        }

        protected Control createButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.mBtnRecurseSubPackages = new Button(composite, 32);
            this.mBtnRecurseSubPackages.setText("Recursivly exclude sub-packages");
            GridData gd = new GridData();
            gd.horizontalAlignment = 1;
            gd.horizontalIndent = 5;
            this.mBtnRecurseSubPackages.setLayoutData((Object)gd);
            this.mBtnRecurseSubPackages.setSelection(this.mRecursivlyExcludeSubPackages);
            this.mBtnRecurseSubPackages.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CheckedTreeSelectionDialog.this.mRecursivlyExcludeSubPackages = CheckedTreeSelectionDialog.this.mBtnRecurseSubPackages.getSelection();
                    CheckedTreeSelectionDialog.this.adaptRecurseBehaviour();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Control buttonBar = super.createButtonBar(composite);
            gd = new GridData(768);
            gd.horizontalAlignment = 3;
            buttonBar.setLayoutData((Object)gd);
            return composite;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label messageLabel = this.createMessageArea(composite);
            CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
            GridData data = new GridData(1808);
            data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            Tree treeWidget = treeViewer.getTree();
            treeWidget.setLayoutData((Object)data);
            treeWidget.setFont(parent.getFont());
            if (this.fIsEmpty) {
                messageLabel.setEnabled(false);
                treeWidget.setEnabled(false);
            }
            return composite;
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            this.fViewer = new CheckboxTreeViewer(parent, 2048);
            this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    IContainer element = (IContainer)event.getElement();
                    if (CheckedTreeSelectionDialog.this.isRecursivlyExcludeSubTree() && !CheckedTreeSelectionDialog.this.isGrayed(element)) {
                        CheckedTreeSelectionDialog.this.setSubElementsGrayedChecked(element, event.getChecked());
                    } else if (CheckedTreeSelectionDialog.this.isRecursivlyExcludeSubTree() && CheckedTreeSelectionDialog.this.isGrayed(element)) {
                        CheckedTreeSelectionDialog.this.fViewer.setGrayChecked((Object)element, true);
                    }
                }
            });
            this.fViewer.setInput(this.fInput);
            this.fViewer.setCheckedElements(this.getInitialElementSelections().toArray());
            this.adaptRecurseBehaviour();
            if (this.fExpandedElements != null) {
                this.fViewer.setExpandedElements(this.fExpandedElements);
            }
            return this.fViewer;
        }

        private boolean evaluateIfTreeEmpty(Object input) {
            Object[] elements = this.fContentProvider.getElements(input);
            return elements.length == 0;
        }

        private void adaptRecurseBehaviour() {
            if (this.isRecursivlyExcludeSubTree()) {
                Object[] checked;
                Object[] objectArray = checked = this.fViewer.getCheckedElements();
                int n = checked.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    this.setSubElementsGrayedChecked((IContainer)element, true);
                    ++n2;
                }
            } else {
                Object[] grayed;
                Object[] objectArray = grayed = this.fViewer.getGrayedElements();
                int n = grayed.length;
                int n3 = 0;
                while (n3 < n) {
                    Object element = objectArray[n3];
                    this.fViewer.setGrayChecked(element, false);
                    ++n3;
                }
            }
        }

        private boolean isGrayed(Object element) {
            Object[] grayed = this.fViewer.getGrayedElements();
            return Arrays.asList(grayed).contains(element);
        }

        private void setSubElementsGrayedChecked(final IContainer container, boolean checked) {
            final ArrayList subContainers = new ArrayList();
            try {
                container.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        if (!resource.equals((Object)container) && resource instanceof IContainer) {
                            subContainers.add((IContainer)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                CheckstyleUIPlugin.errorDialog(this.getShell(), e, true);
            }
            for (IContainer grayedChild : subContainers) {
                this.fViewer.setGrayChecked((Object)grayedChild, checked);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceFolderContentProvider
    implements ITreeContentProvider {
        private SourceFolderContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            List<IResource> children = null;
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                children = this.handleProject(project);
            } else if (parentElement instanceof IContainer) {
                IContainer container = (IContainer)parentElement;
                children = this.handleContainer(container);
            } else {
                children = new ArrayList<IResource>();
            }
            return children.toArray();
        }

        private List<IResource> handleProject(IProject project) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (project.isAccessible()) {
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (javaProject.exists()) {
                        IPackageFragmentRoot[] packageRoots = javaProject.getAllPackageFragmentRoots();
                        int i = 0;
                        int size = packageRoots.length;
                        while (i < size) {
                            if (project.equals((Object)packageRoots[i].getResource())) {
                                IResource[] members = project.members();
                                int j = 0;
                                while (j < members.length) {
                                    if (members[j].getType() != 1) {
                                        children.add(members[j]);
                                    }
                                    ++j;
                                }
                            } else if (!packageRoots[i].isArchive() && packageRoots[i].getParent().equals(javaProject)) {
                                children.add(packageRoots[i].getResource());
                            }
                            ++i;
                        }
                    }
                }
                catch (JavaModelException e) {
                    CheckstyleLog.log((Throwable)e);
                }
                catch (CoreException coreException) {}
            }
            return children;
        }

        private List<IResource> handleContainer(IContainer container) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (container.isAccessible()) {
                try {
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i].getType() != 1) {
                            children.add(members[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            return children;
        }

        public Object getParent(Object element) {
            return element instanceof IResource ? ((IResource)element).getParent() : null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

