/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.duplicates;

import java.util.LinkedList;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.duplicates.DuplicatedCode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DuplicatedCodeView
extends ViewPart {
    public static final String VIEW_ID = "net.sf.eclipsecs.ui.duplicatesView";
    public static final String STRICT_DUPLICATE_CODE_MODULE_NAME = "StrictDuplicateCode";
    private TreeViewer mViewer;
    private DrillDownAdapter mDrillDownAdapter;
    private Action mOpenSourceFileAction;
    private Action mOpenDuplicatedCodeFileAction;
    private final IResourceChangeListener mResourceListener = new IResourceChangeListener(){

        public void resourceChanged(final IResourceChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DuplicatedCodeView.this.mViewer.refresh((Object)event.getResource(), true);
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.mViewer = new TreeViewer(parent, 774);
        this.mDrillDownAdapter = new DrillDownAdapter(this.mViewer);
        this.mViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.mViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.mViewer.addFilter((ViewerFilter)new DuplicatesFilter());
        this.mViewer.setInput((Object)CheckstyleUIPlugin.getWorkspace().getRoot());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.mResourceListener);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DuplicatedCodeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mViewer.getControl());
        this.mViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.mViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.mOpenSourceFileAction);
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        if (selection.getFirstElement() instanceof IMarker) {
            manager.add((IAction)this.mOpenDuplicatedCodeFileAction);
        }
        manager.add((IContributionItem)new Separator());
        this.mDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.mDrillDownAdapter.addNavigationActions(bars.getToolBarManager());
        Action mRefreshAction = new Action(){

            public void run() {
                Job job = new Job(Messages.DuplicatedCodeView_runningCheckstyleToRefresh){

                    protected IStatus run(IProgressMonitor monitor) {
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < projects.length) {
                            IProject project = projects[i];
                            try {
                                if (project.hasNature("net.sf.eclipsecs.core.CheckstyleNature")) {
                                    project.build(6, "net.sf.eclipsecs.core.CheckstyleBuilder", null, monitor);
                                }
                            }
                            catch (CoreException e) {
                                CheckstyleLog.log((Throwable)e, (String)NLS.bind((String)Messages.errorWhileBuildingProject, (Object)project.getName()));
                                return new Status(4, "net.sf.eclipsecs.ui", 0, NLS.bind((String)Messages.errorWhileBuildingProject, (Object)project.getName()), (Throwable)e);
                            }
                            ++i;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                DuplicatedCodeView.this.mViewer.refresh();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        mRefreshAction.setText(Messages.DuplicatedCodeView_refreshAction);
        mRefreshAction.setToolTipText(Messages.DuplicatedCodeView_refreshActionTooltip);
        mRefreshAction.setImageDescriptor(CheckstyleUIPluginImages.REFRESH_ICON);
        bars.getToolBarManager().add((IAction)mRefreshAction);
    }

    private void makeActions() {
        this.createOpenSourceFileAction();
        this.createOpenDuplicatedCodeFileAction();
    }

    private void createOpenSourceFileAction() {
        this.mOpenSourceFileAction = new Action(){

            public void run() {
                try {
                    IStructuredSelection selection = (IStructuredSelection)DuplicatedCodeView.this.mViewer.getSelection();
                    if (selection.getFirstElement() instanceof IFile) {
                        IDE.openEditor((IWorkbenchPage)DuplicatedCodeView.this.getSite().getPage(), (IFile)((IFile)selection.getFirstElement()));
                    } else if (selection.getFirstElement() instanceof IMarker) {
                        IMarker duplicateMarker = (IMarker)selection.getFirstElement();
                        DuplicatedCode duplicatedCode = new DuplicatedCode((IFile)duplicateMarker.getResource(), (Integer)duplicateMarker.getAttribute("lineNumber"), (String)duplicateMarker.getAttribute("message"));
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)DuplicatedCodeView.this.getSite().getPage(), (IFile)duplicatedCode.getSourceFile());
                        if (editorPart instanceof ITextEditor) {
                            DuplicatedCodeView.this.selectAndRevealDuplicatedLines((ITextEditor)editorPart, duplicatedCode.getSourceFileFirstLineNumber(), duplicatedCode.getSourceFileFirstLineNumber() + duplicatedCode.getNumberOfDuplicatedLines());
                        }
                    }
                }
                catch (PartInitException e) {
                    CheckstyleUIPlugin.errorDialog(DuplicatedCodeView.this.mViewer.getControl().getShell(), Messages.errorWhileOpeningEditor, e, true);
                }
                catch (CoreException e) {
                    CheckstyleUIPlugin.errorDialog(DuplicatedCodeView.this.mViewer.getControl().getShell(), Messages.errorWhileOpeningEditor, e, true);
                }
            }
        };
        this.mOpenSourceFileAction.setText(Messages.DuplicatedCodeView_openSourceAction);
        this.mOpenSourceFileAction.setToolTipText(Messages.DuplicatedCodeView_openSourceActionTooltip);
        this.mOpenSourceFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
    }

    private void createOpenDuplicatedCodeFileAction() {
        this.mOpenDuplicatedCodeFileAction = new Action(){

            public void run() {
                try {
                    IStructuredSelection selection = (IStructuredSelection)DuplicatedCodeView.this.mViewer.getSelection();
                    if (selection.getFirstElement() instanceof IMarker) {
                        IMarker duplicateMarker = (IMarker)selection.getFirstElement();
                        DuplicatedCode duplicatedCode = new DuplicatedCode((IFile)duplicateMarker.getResource(), (Integer)duplicateMarker.getAttribute("lineNumber"), (String)duplicateMarker.getAttribute("message"));
                        IFile destinationFile = duplicatedCode.getTargetFile();
                        if (destinationFile == null) {
                            return;
                        }
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)DuplicatedCodeView.this.getSite().getPage(), (IFile)destinationFile);
                        if (editorPart instanceof ITextEditor) {
                            DuplicatedCodeView.this.selectAndRevealDuplicatedLines((ITextEditor)editorPart, duplicatedCode.getTargetFileFirstLineNumber(), duplicatedCode.getTargetFileFirstLineNumber() + duplicatedCode.getNumberOfDuplicatedLines());
                        }
                    }
                }
                catch (PartInitException e) {
                    CheckstyleUIPlugin.errorDialog(DuplicatedCodeView.this.mViewer.getControl().getShell(), Messages.errorWhileOpeningEditor, e, true);
                }
                catch (CoreException e) {
                    CheckstyleUIPlugin.errorDialog(DuplicatedCodeView.this.mViewer.getControl().getShell(), Messages.errorWhileOpeningEditor, e, true);
                }
            }
        };
        this.mOpenDuplicatedCodeFileAction.setText(Messages.DuplicatedCodeView_openTargetAction);
        this.mOpenDuplicatedCodeFileAction.setToolTipText(Messages.DuplicatedCodeView_openTargetActionTooltip);
        this.mOpenDuplicatedCodeFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
    }

    protected void selectAndRevealDuplicatedLines(ITextEditor editor, int firstLine, int lastLine) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int start = document.getLineOffset(firstLine);
            if (firstLine != 0) {
                start = document.getLineOffset(firstLine - 1);
            }
            int end = document.getLineOffset(lastLine - 2) + document.getLineLength(lastLine - 2);
            editor.selectAndReveal(start, end - start - 1);
        }
        catch (BadLocationException e) {
            CheckstyleUIPlugin.errorDialog(this.mViewer.getControl().getShell(), Messages.errorWhileDisplayingDuplicates, e, true);
        }
    }

    private void hookDoubleClickAction() {
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DuplicatedCodeView.this.mViewer.getSelection();
                DuplicatedCodeView.this.mOpenSourceFileAction.run();
                if (selection.getFirstElement() instanceof DuplicatedCode) {
                    DuplicatedCodeView.this.mOpenDuplicatedCodeFileAction.run();
                }
            }
        });
    }

    public void setFocus() {
        this.mViewer.getControl().setFocus();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.mResourceListener);
        super.dispose();
    }

    class DuplicatesFilter
    extends ViewerFilter {
        DuplicatesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            try {
                if (element instanceof IProject) {
                    return ((IProject)element).hasNature("net.sf.eclipsecs.core.CheckstyleNature");
                }
                if (element instanceof IFile) {
                    boolean result = false;
                    IMarker[] markers = ((IFile)element).findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
                    int i = 0;
                    while (i < markers.length) {
                        if (DuplicatedCodeView.STRICT_DUPLICATE_CODE_MODULE_NAME.equals(markers[i].getAttribute("ModuleName"))) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                    return result;
                }
                if (element instanceof IMarker) {
                    return DuplicatedCodeView.STRICT_DUPLICATE_CODE_MODULE_NAME.equals(((IMarker)element).getAttribute("ModuleName"));
                }
            }
            catch (CoreException coreException) {
                return false;
            }
            return true;
        }
    }

    class ViewContentProvider
    extends BaseWorkbenchContentProvider {
        ViewContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProject) {
                final LinkedList files = new LinkedList();
                IResourceVisitor visitor = new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile) {
                            files.add(resource);
                            return false;
                        }
                        return true;
                    }
                };
                try {
                    ((IProject)parentElement).accept(visitor);
                }
                catch (CoreException coreException) {
                    return new Object[0];
                }
                return files.toArray();
            }
            if (parentElement instanceof IFile) {
                try {
                    return ((IFile)parentElement).findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
                }
                catch (CoreException coreException) {
                    return new Object[0];
                }
            }
            return super.getChildren(parentElement);
        }
    }
}

