/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import java.text.Collator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigPropertyWidgetMultiCheck
extends ConfigPropertyWidgetAbstractBase
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final ResourceBundle TOKEN_BUNDLE = PropertyResourceBundle.getBundle("net.sf.eclipsecs.ui.config.token");
    private CheckboxTableViewer mTable;
    private boolean mTranslateTokens;
    private boolean mSortTokens = true;
    private List<String> mTokens;

    public ConfigPropertyWidgetMultiCheck(Composite parent, ConfigProperty prop) {
        super(parent, prop);
        this.mTokens = new ArrayList<String>(prop.getMetaData().getPropertyEnumeration());
    }

    @Override
    protected Control getValueWidget(Composite parent) {
        if (this.mTable == null) {
            this.mTranslateTokens = CheckstyleUIPluginPrefs.getBoolean("translate.checkstyle.tokens");
            this.mSortTokens = CheckstyleUIPluginPrefs.getBoolean("translate.sort.tokens");
            IEclipsePreferences instanceScope = new InstanceScope().getNode("net.sf.eclipsecs.ui");
            instanceScope.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.mTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2560);
            this.mTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.mTable.setLabelProvider((IBaseLabelProvider)new TokenLabelProvider());
            this.installSorter(this.mSortTokens);
            this.mTable.setInput(this.mTokens);
            this.mTable.setCheckedElements(this.getInitialValues().toArray());
            GridData gd = new GridData(1808);
            gd.heightHint = 150;
            this.mTable.getControl().setLayoutData((Object)gd);
            this.mTable.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    IEclipsePreferences prefStore = new InstanceScope().getNode("net.sf.eclipsecs.ui");
                    prefStore.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)ConfigPropertyWidgetMultiCheck.this);
                }
            });
        }
        return this.mTable.getControl();
    }

    @Override
    public String getValue() {
        StringBuffer buffer = new StringBuffer("");
        Object[] checkedElements = this.mTable.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(checkedElements[i]);
            ++i;
        }
        return buffer.toString();
    }

    private List<String> getInitialValues() {
        LinkedList<String> result = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.getInitValue(), ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    private void installSorter(boolean sort) {
        if (sort) {
            Collator collator = Collator.getInstance(CheckstyleUIPlugin.getPlatformLocale());
            this.mTable.setSorter(new ViewerSorter(collator));
        } else {
            this.mTable.setSorter(null);
        }
        this.mTable.refresh();
    }

    @Override
    public void restorePropertyDefault() {
        ConfigPropertyMetadata metadata = this.getConfigProperty().getMetaData();
        String defaultValue = metadata.getOverrideDefault() != null ? metadata.getOverrideDefault() : metadata.getDefaultValue();
        LinkedList<String> result = new LinkedList<String>();
        if (defaultValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(defaultValue, ",");
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken().trim());
            }
        }
        this.mTable.setCheckedElements(new Object[0]);
        this.mTable.setCheckedElements(result.toArray());
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("translate.checkstyle.tokens".equals(event.getKey())) {
            this.mTranslateTokens = Boolean.valueOf((String)event.getNewValue());
            this.mTable.refresh(true);
        }
        if ("translate.sort.tokens".equals(event.getKey())) {
            this.mSortTokens = Boolean.valueOf((String)event.getNewValue());
            this.installSorter(this.mSortTokens);
        }
    }

    private class TokenLabelProvider
    extends LabelProvider {
        private TokenLabelProvider() {
        }

        public String getText(Object element) {
            String translation = null;
            if (!ConfigPropertyWidgetMultiCheck.this.mTranslateTokens) {
                translation = "" + element;
            } else {
                try {
                    translation = TOKEN_BUNDLE.getString((String)element);
                }
                catch (MissingResourceException missingResourceException) {
                    translation = "" + element;
                }
            }
            return translation;
        }
    }
}

