/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.webflow.core.internal.model.ActionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

public abstract class WebflowGraphPreferences {
    private static final Color DEFAULT_COLOR = ColorConstants.button;
    private static final Map<Class, Color> DEFAULT_COLORS = new HashMap<Class, Color>();
    private static Map<Class, Color> classToColorMapCache;
    private static String DEFAULT_COLOR_STRING;

    static {
        DEFAULT_COLORS.put(ViewState.class, ColorFactory.getColor(new RGB(198, 220, 235)));
        DEFAULT_COLORS.put(ActionState.class, ColorFactory.getColor(new RGB(203, 235, 169)));
        DEFAULT_COLORS.put(SubflowState.class, ColorFactory.getColor(new RGB(154, 212, 167)));
        DEFAULT_COLORS.put(DecisionState.class, ColorFactory.getColor(new RGB(255, 239, 169)));
        DEFAULT_COLORS.put(EndState.class, ColorFactory.getColor(new RGB(220, 220, 220)));
        classToColorMapCache = new ConcurrentHashMap<Class, Color>();
        DEFAULT_COLOR_STRING = StringConverter.asString((RGB)DEFAULT_COLOR.getRGB());
    }

    protected static void clearColorCache() {
        classToColorMapCache.clear();
    }

    public static Color getColorForModelElement(IWebflowModelElement element) {
        if (classToColorMapCache.containsKey(element.getClass())) {
            return classToColorMapCache.get(element.getClass());
        }
        Color color = WebflowGraphPreferences.getColorFromPreferences(element.getClass());
        classToColorMapCache.put(element.getClass(), color);
        return color;
    }

    private static Color getColorFromPreferences(Class element) {
        InstanceScope context = new InstanceScope();
        IEclipsePreferences node = context.getNode("org.springframework.ide.eclipse.webflow.ui.graph");
        String value = node.get(WebflowGraphPreferences.getPreferenceName(element.getName()), WebflowGraphPreferences.getDefaultColorStringForModelElementClass(element));
        RGB rgb = StringConverter.asRGB((String)value);
        return ColorFactory.getColor(rgb);
    }

    public static String getDefaultColorStringForModelElementClass(Class element) {
        if (DEFAULT_COLORS.containsKey(element)) {
            return StringConverter.asString((RGB)DEFAULT_COLORS.get(element).getRGB());
        }
        return DEFAULT_COLOR_STRING;
    }

    public static String getPreferenceName(String string) {
        return "org.springframework.ide.eclipse.webflow.ui.graph." + string + ".color";
    }

    public static void setColorForModelElement(Color color, IWebflowModelElement element) {
        WebflowGraphPreferences.setColorToPreferences(element.getClass(), color.getRGB());
        classToColorMapCache.put(element.getClass(), color);
    }

    private static void setColorToPreferences(Class element, RGB rgb) {
        try {
            InstanceScope context = new InstanceScope();
            IEclipsePreferences node = context.getNode("org.springframework.ide.eclipse.webflow.ui.graph");
            node.put(WebflowGraphPreferences.getPreferenceName(element.getName()), StringConverter.asString((RGB)rgb));
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static class ColorFactory {
        private ColorFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Color getColor(final RGB rgb) {
            Display display1 = Display.getCurrent();
            if (display1 != null) {
                return new Color((Device)display1, rgb);
            }
            final Display display2 = Display.getDefault();
            final Color[] result = new Color[1];
            display2.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Color[] colorArray = result;
                    synchronized (result) {
                        result[0] = new Color((Device)display2, rgb);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            Color[] colorArray = result;
            synchronized (result) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return result[0];
            }
        }
    }
}

