/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AddActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AddAttributeMapperCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AddExceptionHandlerCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AddIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateAttributeMapperCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateExceptionHandlerCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateStateCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.IfPart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateSelectionEditPolicy;

public class FlowStateLayoutEditPolicy
extends LayoutEditPolicy {
    protected Command createAddActionCommand(EditPart child) {
        IActionElement activity = (IActionElement)child.getModel();
        AddActionCommand add = new AddActionCommand();
        add.setParent((IWebflowModelElement)this.getHost().getModel());
        add.setChild(activity);
        return add;
    }

    protected Command createAddAttributeMapperCommand(EditPart child) {
        IAttributeMapper activity = (IAttributeMapper)child.getModel();
        AddAttributeMapperCommand add = new AddAttributeMapperCommand();
        add.setParent((ISubflowState)this.getHost().getModel());
        add.setChild(activity);
        return add;
    }

    protected Command createAddIfCommand(EditPart child) {
        IIf activity = (IIf)child.getModel();
        AddIfCommand add = new AddIfCommand();
        add.setParent((IDecisionState)this.getHost().getModel());
        add.setChild(activity);
        return add;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof StatePart || child instanceof IfPart) {
            return new StateSelectionEditPolicy();
        }
        return new NonResizableEditPolicy();
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command getAddCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            if (child.getModel() instanceof IActionElement) {
                IActionElement ae = (IActionElement)child.getModel();
                IState state = (IState)this.getHost().getModel();
                if (ae.getType() == IActionElement.ACTION_TYPE.ACTION && state instanceof IActionState || ae.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && state instanceof IViewState || ae.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && state instanceof IState || ae.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && state instanceof ITransitionableFrom) {
                    command.add(this.createAddActionCommand(child));
                }
            } else if (child.getModel() instanceof IExceptionHandler) {
                IState state = (IState)this.getHost().getModel();
                if (!(state instanceof IWebflowState) && !(state instanceof IInlineFlowState)) {
                    command.add(this.createAddExceptionHandlerCommand(child));
                }
            } else if (child.getModel() instanceof IAttributeMapper && this.getHost().getModel() instanceof ISubflowState && ((ISubflowState)this.getHost().getModel()).getAttributeMapper() == null) {
                command.add(this.createAddAttributeMapperCommand(child));
            } else if (child.getModel() instanceof IIf && this.getHost().getModel() instanceof IDecisionState) {
                command.add(this.createAddIfCommand(child));
            }
            ++i;
        }
        return command.unwrap();
    }

    protected Command createAddExceptionHandlerCommand(EditPart child) {
        IExceptionHandler activity = (IExceptionHandler)child.getModel();
        AddExceptionHandlerCommand add = new AddExceptionHandlerCommand();
        add.setParent((IWebflowModelElement)this.getHost().getModel());
        add.setChild(activity);
        return add;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (this.getHost().getModel() instanceof IWebflowState && request.getNewObject() instanceof IState) {
            CreateStateCommand command = new CreateStateCommand();
            command.setParent((IWebflowState)this.getHost().getModel());
            command.setChild((IState)request.getNewObject());
            return command;
        }
        if (this.getHost().getModel() instanceof IInlineFlowState && request.getNewObject() instanceof IState) {
            CreateStateCommand command = new CreateStateCommand();
            command.setParent(((IInlineFlowState)this.getHost().getModel()).getWebFlowState());
            command.setChild((IState)request.getNewObject());
            return command;
        }
        if (this.getHost().getModel() instanceof IState && request.getNewObject() instanceof IActionElement) {
            IActionElement ae = (IActionElement)request.getNewObject();
            IState state = (IState)this.getHost().getModel();
            if (ae.getType() == IActionElement.ACTION_TYPE.ACTION && state instanceof IActionState || ae.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && state instanceof IViewState || ae.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && state instanceof IState || ae.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && state instanceof ITransitionableFrom) {
                CreateActionCommand command = new CreateActionCommand();
                command.setParent((IState)this.getHost().getModel());
                command.setChild((IActionElement)request.getNewObject());
                return command;
            }
            return null;
        }
        if (this.getHost().getModel() instanceof IState && !(this.getHost().getModel() instanceof IWebflowState) && !(this.getHost().getModel() instanceof IInlineFlowState) && request.getNewObject() instanceof IExceptionHandler) {
            CreateExceptionHandlerCommand command = new CreateExceptionHandlerCommand();
            command.setParent((IState)this.getHost().getModel());
            command.setChild((IExceptionHandler)request.getNewObject());
            return command;
        }
        if (this.getHost().getModel() instanceof ISubflowState && request.getNewObject() instanceof IAttributeMapper) {
            if (((ISubflowState)this.getHost().getModel()).getAttributeMapper() == null) {
                CreateAttributeMapperCommand command = new CreateAttributeMapperCommand();
                command.setParent((ISubflowState)this.getHost().getModel());
                return command;
            }
            return null;
        }
        if (this.getHost().getModel() instanceof IDecisionState && request.getNewObject() instanceof IIf) {
            CreateIfCommand command = new CreateIfCommand();
            command.setParent((IDecisionState)this.getHost().getModel());
            command.setChild((IIf)request.getNewObject());
            return command;
        }
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }
}

