/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateTreeContainerEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateTreeEditPolicy;

public class StateTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    protected static ILabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator());
    protected static WebflowModelLabelProvider tLabelProvider = new WebflowModelLabelProvider();

    public void activate() {
        super.activate();
        if (this.getModel() != null) {
            ((IWebflowModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StateEditPolicy());
        this.installEditPolicy("TreeContainerEditPolicy", (EditPolicy)new StateTreeContainerEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new StateTreeEditPolicy());
    }

    public void deactivate() {
        if (this.getModel() != null) {
            ((IWebflowModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.deactivate();
    }

    protected List getModelChildren() {
        IState state;
        IAttributeEnabled properties;
        ArrayList<IAttributeMapper> children = new ArrayList<IAttributeMapper>();
        if (this.getModel() instanceof IAttributeEnabled && (properties = (IAttributeEnabled)this.getModel()).getAttributes() != null) {
            children.addAll(properties.getAttributes());
        }
        if (this.getModel() instanceof IState && !(this.getModel() instanceof IWebflowState) && (state = (IState)this.getModel()).getEntryActions() != null) {
            children.addAll(state.getEntryActions().getEntryActions());
        }
        if (this.getModel() instanceof IActionState && ((IActionState)this.getState()).getActions() != null) {
            children.addAll(((IActionState)this.getState()).getActions());
        }
        if (this.getModel() instanceof IViewState) {
            if (((IViewState)this.getState()).getRenderActions() != null) {
                children.addAll(((IViewState)this.getState()).getRenderActions().getRenderActions());
            }
        } else if (this.getModel() instanceof ISubflowState) {
            if (((ISubflowState)this.getModel()).getAttributeMapper() != null) {
                children.add(((ISubflowState)this.getModel()).getAttributeMapper());
            }
        } else if (this.getModel() instanceof IInlineFlowState) {
            children.addAll(((IInlineFlowState)this.getModel()).getWebFlowState().getStates());
            children.addAll(((IInlineFlowState)this.getModel()).getWebFlowState().getInlineFlowStates());
        } else if (this.getModel() instanceof IWebflowState) {
            if (((IWebflowState)this.getState()).getStates() != null && ((IWebflowState)this.getState()).getInlineFlowStates() != null) {
                children.addAll(((IWebflowState)this.getState()).getStates());
                children.addAll(((IWebflowState)this.getState()).getInlineFlowStates());
            }
        } else if (this.getModel() instanceof IDecisionState && ((IDecisionState)this.getModel()).getIfs() != null) {
            children.addAll(((IDecisionState)this.getModel()).getIfs());
        }
        if (this.getModel() instanceof IState && !(this.getModel() instanceof IWebflowState)) {
            state = (IState)this.getModel();
            if (state.getExitActions() != null) {
                children.addAll(state.getExitActions().getExitActions());
            }
            if (state.getExceptionHandlers() != null) {
                children.addAll(state.getExceptionHandlers());
            }
        }
        return children;
    }

    protected IState getState() {
        return (IState)this.getModel();
    }

    public void propertyChange(PropertyChangeEvent change) {
        if (change.getPropertyName().equals("add_children")) {
            this.addChild(this.createChild(change.getNewValue()), (Integer)change.getOldValue());
        } else if (change.getPropertyName().equals("remove_children")) {
            this.removeChild((EditPart)this.getViewer().getEditPartRegistry().get(change.getNewValue()));
        } else if (change.getPropertyName().equals("move_children")) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        Image image = labelProvider.getImage(this.getModel());
        String text = tLabelProvider.getText(this.getModel(), true, false, false);
        if (image != null) {
            this.setWidgetImage(image);
        }
        this.setWidgetText(text);
    }
}

