/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.InputMapperComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.OutputMapperComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class SubFlowStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private ISubflowState state;
    private ISubflowState stateClone;
    private Label nameLabel;
    private Text nameText;
    private Label flowLabel;
    private Text flowText;
    private Label attributeMapperBeanLabel;
    private Text attributeMapperBeanText;
    private Button okButton;
    private Button browseBeanButton;
    private Button browseFlowButton;
    private IWebflowModelElement parentElement;
    private PropertiesComposite properties;
    private ActionComposite entryActionsComposite;
    private ActionComposite exitActionsComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private OutputMapperComposite outputMapperComposite;
    private InputMapperComposite inputMapperComposite;
    private List<IActionElement> entryActions;
    private List<IActionElement> exitActions;
    private List<IOutputAttribute> outputAttributes;
    private List<IMapping> outputMapping;
    private List<IInputAttribute> inputAttributes;
    private List<IMapping> inputMapping;
    private int index = -1;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SubFlowStatePropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private List<IExceptionHandler> exceptionHandler;
    private Label parentLabel;
    private Text parentText;

    public SubFlowStatePropertiesDialog(Shell parentShell, IWebflowModelElement parent, ISubflowState state, int tabIndex) {
        super(parentShell);
        this.state = state;
        this.parentElement = parent;
        this.stateClone = ((SubflowState)state).cloneModelElement();
        if (this.stateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.stateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            EntryActions entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.stateClone.getExitActions() != null) {
            this.exitActions = new ArrayList<IActionElement>();
            this.exitActions.addAll(this.stateClone.getExitActions().getExitActions());
        } else {
            this.exitActions = new ArrayList<IActionElement>();
            ExitActions exit = new ExitActions();
            exit.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setExitActions((IExitActions)exit);
        }
        this.outputAttributes = new ArrayList<IOutputAttribute>();
        this.outputMapping = new ArrayList<IMapping>();
        this.inputAttributes = new ArrayList<IInputAttribute>();
        this.inputMapping = new ArrayList<IMapping>();
        if (this.stateClone.getAttributeMapper() != null) {
            if (this.stateClone.getAttributeMapper().getOutputMapper() != null) {
                this.outputAttributes.addAll(this.stateClone.getAttributeMapper().getOutputMapper().getOutputAttributes());
                this.outputMapping.addAll(this.stateClone.getAttributeMapper().getOutputMapper().getMapping());
            } else {
                OutputMapper o = new OutputMapper();
                o.createNew((IWebflowModelElement)this.stateClone.getAttributeMapper());
                this.stateClone.getAttributeMapper().setOutputMapper((IOutputMapper)o);
            }
            if (this.stateClone.getAttributeMapper().getInputMapper() != null) {
                this.inputAttributes.addAll(this.stateClone.getAttributeMapper().getInputMapper().getInputAttributes());
                this.inputMapping.addAll(this.stateClone.getAttributeMapper().getInputMapper().getMapping());
            } else {
                InputMapper i = new InputMapper();
                i.createNew((IWebflowModelElement)this.stateClone.getAttributeMapper());
                this.stateClone.getAttributeMapper().setInputMapper((IInputMapper)i);
            }
        } else {
            AttributeMapper mapper = new AttributeMapper();
            mapper.createNew((IWebflowModelElement)this.stateClone);
            OutputMapper o = new OutputMapper();
            o.createNew((IWebflowModelElement)mapper);
            mapper.setOutputMapper((IOutputMapper)o);
            InputMapper i = new InputMapper();
            i.createNew((IWebflowModelElement)mapper);
            mapper.setInputMapper((IInputMapper)i);
            this.stateClone.setAttributeMapper((IAttributeMapper)mapper);
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)state)) {
                this.outputAttributes.addAll(this.stateClone.getOutputAttributes());
                this.inputAttributes.addAll(this.stateClone.getInputAttributes());
            }
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.stateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.stateClone.getExceptionHandlers());
        }
        this.index = tabIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.stateClone.setId(this.trimString(this.nameText.getText()));
            this.stateClone.setFlow(this.trimString(this.flowText.getText()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
                this.stateClone.setParent(this.trimString(this.parentText.getText()));
            }
            if (this.state.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.stateClone);
                for (IActionElement iActionElement : this.entryActions) {
                    entryActions.addEntryAction(iActionElement);
                }
                this.stateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.stateClone.setEntryActions(null);
            } else {
                this.stateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.stateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.state.getExitActions() == null && this.exitActions.size() > 0) {
                ExitActions exitActions = new ExitActions();
                exitActions.createNew((IWebflowModelElement)this.stateClone);
                for (IActionElement iActionElement : this.exitActions) {
                    exitActions.addExitAction(iActionElement);
                }
                this.stateClone.setExitActions((IExitActions)exitActions);
            } else if (this.exitActions.size() == 0) {
                this.stateClone.setExitActions(null);
            } else {
                this.stateClone.getExitActions().removeAll();
                for (IActionElement iActionElement : this.exitActions) {
                    this.stateClone.getExitActions().addExitAction(iActionElement);
                }
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.stateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.stateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.stateClone.removeAllExceptionHandler();
            }
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
                if (this.trimString(this.attributeMapperBeanText.getText()) != null || this.inputAttributes.size() > 0 || this.outputAttributes.size() > 0 || this.outputMapping.size() > 0 || this.inputMapping.size() > 0) {
                    void var2_14;
                    Object var2_11 = null;
                    if (this.stateClone.getAttributeMapper() == null) {
                        AttributeMapper attributeMapper = new AttributeMapper();
                        attributeMapper.createNew((IWebflowModelElement)this.stateClone);
                        this.stateClone.setAttributeMapper((IAttributeMapper)attributeMapper);
                    } else {
                        IAttributeMapper iAttributeMapper = this.stateClone.getAttributeMapper();
                    }
                    var2_14.setBean(this.trimString(this.attributeMapperBeanText.getText()));
                    if (var2_14.getOutputMapper() == null && (this.outputAttributes.size() > 0 || this.outputMapping.size() > 0)) {
                        OutputMapper outputMapper = new OutputMapper();
                        outputMapper.createNew((IWebflowModelElement)var2_14);
                        for (IInputAttribute iInputAttribute : this.outputAttributes) {
                            outputMapper.addOutputAttribute((IOutputAttribute)iInputAttribute);
                        }
                        for (IMapping iMapping : this.outputMapping) {
                            outputMapper.addMapping(iMapping);
                        }
                        var2_14.setOutputMapper((IOutputMapper)outputMapper);
                    } else if (this.outputAttributes.size() == 0 && this.outputMapping.size() == 0) {
                        var2_14.setOutputMapper(null);
                    } else {
                        var2_14.getOutputMapper().removeAllOutputAttribute();
                        var2_14.getOutputMapper().removeAllMapping();
                        for (IInputAttribute iInputAttribute : this.outputAttributes) {
                            var2_14.getOutputMapper().addOutputAttribute((IOutputAttribute)iInputAttribute);
                        }
                        for (IMapping iMapping : this.outputMapping) {
                            var2_14.getOutputMapper().addMapping(iMapping);
                        }
                    }
                    if (var2_14.getInputMapper() == null && (this.inputAttributes.size() > 0 || this.inputMapping.size() > 0)) {
                        InputMapper inputMapper = new InputMapper();
                        inputMapper.createNew((IWebflowModelElement)var2_14);
                        for (IInputAttribute iInputAttribute : this.inputAttributes) {
                            inputMapper.addInputAttribute(iInputAttribute);
                        }
                        for (IMapping iMapping : this.inputMapping) {
                            inputMapper.addMapping(iMapping);
                        }
                        var2_14.setInputMapper((IInputMapper)inputMapper);
                    } else if (this.inputAttributes.size() == 0 && this.inputMapping.size() == 0) {
                        var2_14.setInputMapper(null);
                    } else {
                        var2_14.getInputMapper().removeAllInputAttribute();
                        var2_14.getInputMapper().removeAllMapping();
                        for (IInputAttribute iInputAttribute : this.inputAttributes) {
                            var2_14.getInputMapper().addInputAttribute(iInputAttribute);
                        }
                        for (IMapping iMapping : this.inputMapping) {
                            var2_14.getInputMapper().addMapping(iMapping);
                        }
                    }
                } else {
                    this.stateClone.removeAttributeMapper();
                }
            } else if (this.trimString(this.attributeMapperBeanText.getText()) != null || this.inputAttributes.size() > 0 || this.outputAttributes.size() > 0 || this.outputMapping.size() > 0 || this.inputMapping.size() > 0) {
                this.stateClone.setSubflowAttributeMapper(this.attributeMapperBeanText.getText());
                this.stateClone.removeAllInputAttribute();
                for (IInputAttribute iInputAttribute : this.inputAttributes) {
                    this.stateClone.addInputAttribute(iInputAttribute);
                }
                this.stateClone.removeAllOutputAttribute();
                for (IOutputAttribute iOutputAttribute : this.outputAttributes) {
                    this.stateClone.addOutputAttribute(iOutputAttribute);
                }
                this.stateClone.removeAttributeMapper();
            }
            ((ICloneableModelElement)this.state).applyCloneValues((IWebflowModelElement)this.stateClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.state != null && this.state.getId() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Subflow State ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("State id");
        this.nameText = new Text(nameGroup, 2052);
        if (this.state != null && this.state.getId() != null) {
            this.nameText.setText(this.state.getId());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SubFlowStatePropertiesDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.flowLabel = new Label(nameGroup, 0);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
            this.flowLabel.setText("Flow");
        } else {
            this.flowLabel.setText("Subflow");
        }
        DecoratedField flowField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
        FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        flowField.addFieldDecoration(requiredFieldIndicator, 16512, true);
        this.flowText = (Text)flowField.getControl();
        GridData data = new GridData(256);
        flowField.getLayoutControl().setLayoutData((Object)data);
        if (this.state != null && this.state.getFlow() != null) {
            this.flowText.setText(this.state.getFlow());
        }
        this.flowText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SubFlowStatePropertiesDialog.this.validateInput();
            }
        });
        data = new GridData(768);
        data.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.nameText.setLayoutData((Object)data);
        DialogUtils.attachContentAssist(this.flowText, WebflowUtils.getWebflowConfigNames());
        this.browseFlowButton = new Button(nameGroup, 8);
        this.browseFlowButton.setText("...");
        this.browseFlowButton.setLayoutData((Object)new GridData(128));
        this.browseFlowButton.addSelectionListener(this.buttonListener);
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.state != null && this.state.getParent() != null) {
                this.parentText.setText(this.state.getParent());
            }
            this.parentText.setLayoutData((Object)data);
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SubFlowStatePropertiesDialog.this.validateInput();
                }
            });
            new Label(nameGroup, 0);
        }
        item1.setControl((Control)groupActionType);
        item2.setText("Attribute Mapper");
        item2.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.attribute_mapper_obj.gif"));
        Composite attributeMapperGroup = new Composite((Composite)folder, 0);
        attributeMapperGroup.setLayoutData((Object)new GridData(1808));
        layout1 = new GridLayout();
        layout1.numColumns = 1;
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        attributeMapperGroup.setLayout((Layout)layout1);
        Group attributeMapperType = new Group(attributeMapperGroup, 0);
        layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        attributeMapperType.setText(" Attribute Mapper ");
        attributeMapperType.setLayoutData((Object)new GridData(1808));
        attributeMapperType.setLayout((Layout)layoutAttMap);
        Composite attributeMapperTypeGroup = new Composite((Composite)attributeMapperType, 0);
        attributeMapperTypeGroup.setLayoutData((Object)new GridData(768));
        layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        attributeMapperTypeGroup.setLayout((Layout)layout1);
        this.attributeMapperBeanLabel = new Label(attributeMapperTypeGroup, 0);
        this.attributeMapperBeanLabel.setText("Bean");
        DecoratedField beanField = new DecoratedField(attributeMapperTypeGroup, 2052, (IControlCreator)new TextControlCreator());
        FieldDecoration requiredFieldIndicator3 = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        beanField.addFieldDecoration(requiredFieldIndicator3, 16512, true);
        this.attributeMapperBeanText = (Text)beanField.getControl();
        data = new GridData(768);
        beanField.getLayoutControl().setLayoutData((Object)data);
        if (this.state != null && this.state.getAttributeMapper() != null && this.state.getAttributeMapper().getBean() != null) {
            this.attributeMapperBeanText.setText(this.state.getAttributeMapper().getBean());
        }
        if (this.state != null && this.state.getSubflowAttributeMapper() != null) {
            this.attributeMapperBeanText.setText(this.state.getSubflowAttributeMapper());
        }
        this.attributeMapperBeanText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SubFlowStatePropertiesDialog.this.validateInput();
            }
        });
        DialogUtils.attachContentAssist(this.attributeMapperBeanText, WebflowUtils.getBeansFromEditorInput().toArray());
        this.browseBeanButton = new Button(attributeMapperTypeGroup, 8);
        this.browseBeanButton.setText("...");
        this.browseBeanButton.setLayoutData((Object)new GridData(128));
        this.browseBeanButton.addSelectionListener(this.buttonListener);
        TabFolder folder2 = new TabFolder(attributeMapperGroup, 0);
        folder2.setLayoutData((Object)new GridData(1808));
        TabItem item21 = new TabItem(folder2, 0);
        TabItem item22 = new TabItem(folder2, 0);
        this.inputMapperComposite = new InputMapperComposite(this, item21, this.getShell(), this.inputAttributes, this.inputMapping, this.stateClone.getAttributeMapper().getInputMapper());
        item21.setControl(this.inputMapperComposite.createDialogArea((Composite)folder2));
        this.outputMapperComposite = new OutputMapperComposite(this, item22, this.getShell(), this.outputAttributes, this.outputMapping, this.stateClone.getAttributeMapper().getOutputMapper());
        item22.setControl(this.outputMapperComposite.createDialogArea((Composite)folder2));
        item2.setControl((Control)attributeMapperGroup);
        this.entryActionsComposite = new ActionComposite(this, item3, this.getShell(), this.entryActions, (IWebflowModelElement)this.stateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item3.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.exitActionsComposite = new ActionComposite(this, item4, this.getShell(), this.exitActions, (IWebflowModelElement)this.stateClone.getExitActions(), IActionElement.ACTION_TYPE.EXIT_ACTION);
        item4.setControl(this.exitActionsComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item5, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.stateClone);
        item5.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item6, this.getShell(), (IAttributeEnabled)this.stateClone);
        item6.setControl(this.properties.createDialogArea((Composite)folder));
        SubFlowStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        if (this.index >= 0) {
            folder.setSelection(this.index);
        }
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.subflow_state_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the subflow state";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parentElement;
    }

    protected String getShellTitle() {
        return "Subflow State";
    }

    protected String getTitle() {
        return "Subflow State properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    private void handleButtonPressed(Button button) {
        ElementListSelectionDialog dialog;
        if (button.equals(this.browseBeanButton)) {
            ElementListSelectionDialog dialog2 = DialogUtils.openBeanReferenceDialog(this.attributeMapperBeanText.getText(), false);
            if (dialog2.open() == 0) {
                this.attributeMapperBeanText.setText(((IBean)dialog2.getFirstResult()).getElementName());
            }
        } else if (button.equals(this.browseFlowButton) && (dialog = DialogUtils.openFlowReferenceDialog()).open() == 0) {
            this.flowText.setText((String)dialog.getFirstResult());
        }
    }
}

