/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerComposite {
    private TableViewer configsViewer;
    private Button editButton;
    private Button addButton;
    private Button deleteButton;
    private Shell parentShell;
    private List<IExceptionHandler> exceptionHandler;
    private IWebflowModelElement parentElement;

    public ExceptionHandlerComposite(IDialogValidator validator, TabItem item, Shell parentShell, List<IExceptionHandler> actions, IWebflowModelElement parentElement) {
        this.exceptionHandler = actions;
        item.setText("Exception Handler");
        item.setToolTipText("Define element's exception handler");
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.exception_handler_obj.gif"));
        this.parentShell = parentShell;
        this.parentElement = parentElement;
    }

    protected Control createDialogArea(Composite parent) {
        Group groupActionType = new Group(parent, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Exception Handler ");
        groupActionType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupActionType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 200;
        configsTable.setLayoutData((Object)data);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandlerComposite.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new ExceptionHandlerContentProvider(this.exceptionHandler));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
        this.configsViewer.setInput((Object)this);
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText("Add");
        GridData data1 = new GridData(256);
        this.addButton.setLayoutData((Object)data1);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandler action = new ExceptionHandler();
                action.createNew(ExceptionHandlerComposite.this.parentElement);
                if (DialogUtils.openPropertiesDialog(ExceptionHandlerComposite.this.parentElement, (IWebflowModelElement)action, true) == 0) {
                    ExceptionHandlerComposite.this.exceptionHandler.add(action);
                    ExceptionHandlerComposite.this.configsViewer.refresh();
                }
            }
        });
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        data1 = new GridData(256);
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExceptionHandlerComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof ExceptionHandler && DialogUtils.openPropertiesDialog(ExceptionHandlerComposite.this.parentElement, (IWebflowModelElement)((ExceptionHandler)selection.getFirstElement()), true) == 0) {
                    ExceptionHandlerComposite.this.configsViewer.refresh();
                }
            }
        });
        this.deleteButton = new Button(buttonArea, 8);
        this.deleteButton.setText("Delete");
        data1 = new GridData(256);
        this.deleteButton.setLayoutData((Object)data1);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExceptionHandlerComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof ExceptionHandler) {
                    ExceptionHandler actionElement = (ExceptionHandler)selection.getFirstElement();
                    ExceptionHandlerComposite.this.exceptionHandler.remove(actionElement);
                    ExceptionHandlerComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        return groupActionType;
    }

    protected void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionHandlerContentProvider
    implements IStructuredContentProvider {
        private List<IExceptionHandler> actions;

        public ExceptionHandlerContentProvider(List<IExceptionHandler> actions) {
            this.actions = actions;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.actions.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

