/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IfPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;

public class DecisionStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IDecisionState decisionState;
    private IDecisionState decisionStateClone;
    private Label nameLabel;
    private Text nameText;
    private Button okButton;
    private IWebflowModelElement parent;
    private PropertiesComposite properties;
    private ActionComposite entryActionsComposite;
    private ActionComposite exitActionsComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private List<IActionElement> entryActions;
    private List<IActionElement> exitActions;
    private TableViewer configsViewer;
    private Button editButton;
    private List<IExceptionHandler> exceptionHandler;
    private Label parentLabel;
    private Text parentText;

    public DecisionStatePropertiesDialog(Shell parentShell, IWebflowModelElement parent, IDecisionState state) {
        super(parentShell);
        this.decisionState = state;
        this.parent = parent;
        this.decisionStateClone = ((DecisionState)state).cloneModelElement();
        if (this.decisionStateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.decisionStateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            EntryActions entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.decisionStateClone);
            this.decisionStateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.decisionStateClone.getExitActions() != null) {
            this.exitActions = new ArrayList<IActionElement>();
            this.exitActions.addAll(this.decisionStateClone.getExitActions().getExitActions());
        } else {
            this.exitActions = new ArrayList<IActionElement>();
            ExitActions exit = new ExitActions();
            exit.createNew((IWebflowModelElement)this.decisionStateClone);
            this.decisionStateClone.setExitActions((IExitActions)exit);
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.decisionStateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.decisionStateClone.getExceptionHandlers());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.decisionStateClone.setId(this.trimString(this.getId()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.decisionState)) {
                this.decisionStateClone.setParent(this.trimString(this.getParent()));
            }
            if (this.decisionState.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.decisionStateClone);
                for (IActionElement a : this.entryActions) {
                    entryActions.addEntryAction(a);
                }
                this.decisionStateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.decisionStateClone.setEntryActions(null);
            } else {
                this.decisionStateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.decisionStateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.decisionState.getExitActions() == null && this.exitActions.size() > 0) {
                ExitActions exitActions = new ExitActions();
                exitActions.createNew((IWebflowModelElement)this.decisionStateClone);
                for (IActionElement a : this.exitActions) {
                    exitActions.addExitAction(a);
                }
                this.decisionStateClone.setExitActions((IExitActions)exitActions);
            } else if (this.exitActions.size() == 0) {
                this.decisionStateClone.setExitActions(null);
            } else {
                this.decisionStateClone.getExitActions().removeAll();
                for (IActionElement iActionElement : this.exitActions) {
                    this.decisionStateClone.getExitActions().addExitAction(iActionElement);
                }
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.decisionStateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.decisionStateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.decisionStateClone.removeAllExceptionHandler();
            }
            ((ICloneableModelElement)this.decisionState).applyCloneValues((IWebflowModelElement)this.decisionStateClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.decisionState != null && this.decisionState.getId() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Decision State ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("State id");
        this.nameText = new Text(nameGroup, 2052);
        if (this.decisionState != null && this.decisionState.getId() != null) {
            this.nameText.setText(this.decisionState.getId());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DecisionStatePropertiesDialog.this.validateInput();
            }
        });
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.decisionState)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.decisionState != null && this.decisionState.getParent() != null) {
                this.parentText.setText(this.decisionState.getParent());
            }
            this.parentText.setLayoutData((Object)new GridData(768));
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DecisionStatePropertiesDialog.this.validateInput();
                }
            });
        }
        Group groupIfsType = new Group((Composite)groupActionType, 0);
        layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupIfsType.setLayout((Layout)layoutAttMap);
        groupIfsType.setText(" Ifs ");
        groupIfsType.setLayoutData((Object)new GridData(1808));
        Composite tableAndButtons = new Composite((Composite)groupIfsType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.heightHint = 145;
        configsTable.setLayoutData((Object)data);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecisionStatePropertiesDialog.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new IfContentProvider(this.decisionStateClone));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
        this.configsViewer.setInput((Object)this);
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IfPropertiesDialog dialog;
                IStructuredSelection selection = (IStructuredSelection)DecisionStatePropertiesDialog.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IIf && (dialog = new IfPropertiesDialog(DecisionStatePropertiesDialog.this.getShell(), DecisionStatePropertiesDialog.this.decisionState, (IIf)selection.getFirstElement(), false)).open() == 0) {
                    DecisionStatePropertiesDialog.this.configsViewer.refresh();
                }
            }
        });
        item1.setControl((Control)groupActionType);
        this.entryActionsComposite = new ActionComposite(this, item3, this.getShell(), this.entryActions, (IWebflowModelElement)this.decisionStateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item3.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.exitActionsComposite = new ActionComposite(this, item4, this.getShell(), this.exitActions, (IWebflowModelElement)this.decisionStateClone.getExitActions(), IActionElement.ACTION_TYPE.EXIT_ACTION);
        item4.setControl(this.exitActionsComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item5, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.decisionStateClone);
        item5.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item6, this.getShell(), (IAttributeEnabled)this.decisionStateClone);
        item6.setControl(this.properties.createDialogArea((Composite)folder));
        DecisionStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    public String getParent() {
        return this.parentText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.decision_state_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the decision state";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parent;
    }

    protected String getShellTitle() {
        return "Decision State";
    }

    protected String getTitle() {
        return "Decision State properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    protected void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
    }

    private class IfContentProvider
    implements IStructuredContentProvider {
        private IDecisionState project;

        public IfContentProvider(IDecisionState project) {
            this.project = project;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.project.getIfs().toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

