/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.ActionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.IfTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowImages;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;

public class WebflowEditorPaletteFactory {
    private static List createCategories(PaletteRoot root, boolean version1) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(WebflowEditorPaletteFactory.createControlGroup(root));
        categories.add(WebflowEditorPaletteFactory.createComponentsDrawer(version1));
        categories.add(WebflowEditorPaletteFactory.createActionDrawer(version1));
        categories.add(WebflowEditorPaletteFactory.createRenderActionsDrawer(version1));
        categories.add(WebflowEditorPaletteFactory.createEntryActionDrawer(version1));
        categories.add(WebflowEditorPaletteFactory.createExitActionDrawer(version1));
        return categories;
    }

    private static PaletteContainer createComponentsDrawer(boolean version1) {
        PaletteDrawer drawer = new PaletteDrawer("Web Flow Elements", null);
        ArrayList<Object> entries = new ArrayList<Object>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Action State", "Create a new Action State", ActionState.class, (CreationFactory)new SimpleFactory(ActionState.class), WebflowUIImages.DESC_OBJS_ACTION_STATE, WebflowUIImages.DESC_OBJS_ACTION_STATE);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("View State", "Create a View State", ViewState.class, (CreationFactory)new SimpleFactory(ViewState.class), WebflowUIImages.DESC_OBJS_VIEW_STATE, WebflowUIImages.DESC_OBJS_VIEW_STATE);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Subflow State", "Create a Subflow State", SubflowState.class, (CreationFactory)new SimpleFactory(SubflowState.class), WebflowUIImages.DESC_OBJS_SUBFLOW_STATE, WebflowUIImages.DESC_OBJS_SUBFLOW_STATE);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Decision State", "Create a Decision State", DecisionState.class, (CreationFactory)new SimpleFactory(DecisionState.class), WebflowUIImages.DESC_OBJS_DECISION_STATE, WebflowUIImages.DESC_OBJS_DECISION_STATE);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("End State", "Create an End State", EndState.class, (CreationFactory)new SimpleFactory(EndState.class), WebflowUIImages.DESC_OBJS_END_STATE, WebflowUIImages.DESC_OBJS_END_STATE);
        entries.add(combined);
        PaletteSeparator sep = new PaletteSeparator("org.springframework.ide.eclipse.webflow.ui.editor.palette.sep3");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        combined = new CombinedTemplateCreationEntry("Exception Handler", "Create an Exception Handler", ExceptionHandler.class, (CreationFactory)new SimpleFactory(ExceptionHandler.class), WebflowUIImages.DESC_OBJS_EXCEPTION_HANDLER, WebflowUIImages.DESC_OBJS_EXCEPTION_HANDLER);
        entries.add(combined);
        if (version1) {
            combined = new CombinedTemplateCreationEntry("Attribute Mapper", "Create an Attribute Mapper", AttributeMapper.class, (CreationFactory)new SimpleFactory(AttributeMapper.class), WebflowUIImages.DESC_OBJS_ATTRIBUTE_MAPPER, WebflowUIImages.DESC_OBJS_ATTRIBUTE_MAPPER);
            entries.add(combined);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        PaletteSeparator sep = new PaletteSeparator("org.springframework.ide.eclipse.webflow.ui.editor.palette.sep2");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        tool = new ConnectionCreationToolEntry("Transition", "Create a Transition", (CreationFactory)new SimpleFactory(StateTransition.class), WebflowImages.DESC_OBJS_CONNECTION, WebflowImages.DESC_OBJS_ELSE_CONNECTION);
        entries.add(tool);
        tool = new ConnectionCreationToolEntry("Else Transition", "Create a Transition", (CreationFactory)new SimpleFactory(IfTransition.class), WebflowImages.DESC_OBJS_ELSE_CONNECTION, WebflowImages.DESC_OBJS_ELSE_CONNECTION);
        entries.add(tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public static PaletteRoot createPalette(boolean version1) {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(WebflowEditorPaletteFactory.createCategories(flowPalette, version1));
        return flowPalette;
    }

    private static PaletteContainer createActionDrawer(boolean version1) {
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        PaletteDrawer drawer = new PaletteDrawer("Actions", null);
        drawer.setInitialState(0);
        if (version1) {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Action", "Create a new Action", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_ACTION, WebflowUIImages.DESC_OBJS_ACTION);
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Bean Action", "Create a new Bean Action", BeanAction.class, (CreationFactory)new ActionModelElementFactory(BeanAction.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_BEAN_ACTION, WebflowUIImages.DESC_OBJS_BEAN_ACTION);
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Evaluation Action", "Create a new Evaluation Action", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_EVALUATION_ACTION, WebflowUIImages.DESC_OBJS_EVALUATION_ACTION);
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Set", "Create a new Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_SET_ACTION, WebflowUIImages.DESC_OBJS_SET_ACTION);
            entries.add(combined);
        } else {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Evaluate", "Create a new Evaluate", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_EVALUATION_ACTION, WebflowUIImages.DESC_OBJS_EVALUATION_ACTION);
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Set", "Create a new Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_SET_ACTION, WebflowUIImages.DESC_OBJS_SET_ACTION);
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render", "Create a new Render", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_ACTION, WebflowUIImages.DESC_OBJS_ACTION);
            entries.add(combined);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createRenderActionsDrawer(boolean version1) {
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        RenderActions exit = new RenderActions();
        Action action = new Action();
        action.setElementParent((IWebflowModelElement)exit);
        WebflowModelLabelDecorator dec = new WebflowModelLabelDecorator();
        PaletteDrawer drawer = new PaletteDrawer("Render Actions", null);
        drawer.setInitialState(0);
        if (version1) {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Render Action", "Create a new Render Action", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render Bean Action", "Create a new Render Bean Action", BeanAction.class, (CreationFactory)new ActionModelElementFactory(BeanAction.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render Evaluation Action", "Create a new Render Evaluation Action", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render Set", "Create a new Render Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
        } else {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Render Evaluate", "Create a new Render Evaluate", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render Set", "Create a new Render Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.RENDER_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Render", "Create a new Render", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_ACTION, WebflowUIImages.DESC_OBJS_ACTION);
            entries.add(combined);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createEntryActionDrawer(boolean version1) {
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        EntryActions exit = new EntryActions();
        Action action = new Action();
        action.setElementParent((IWebflowModelElement)exit);
        WebflowModelLabelDecorator dec = new WebflowModelLabelDecorator();
        PaletteDrawer drawer = new PaletteDrawer("Entry Actions", null);
        drawer.setInitialState(1);
        if (version1) {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Entry Action", "Create a new Entry Action", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Entry Bean Action", "Create a new Entry Bean Action", BeanAction.class, (CreationFactory)new ActionModelElementFactory(BeanAction.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Entry Evaluation Action", "Create a new Evaluation Action", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Entry Set", "Create a new Entry Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
        } else {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Entry Evaluate", "Create a new Evaluate", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Entry Set", "Create a new Entry Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.ENTRY_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Entry Render", "Create a new Entry Render", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_ACTION, WebflowUIImages.DESC_OBJS_ACTION);
            entries.add(combined);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createExitActionDrawer(boolean version1) {
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        ExitActions exit = new ExitActions();
        Action action = new Action();
        action.setElementParent((IWebflowModelElement)exit);
        WebflowModelLabelDecorator dec = new WebflowModelLabelDecorator();
        PaletteDrawer drawer = new PaletteDrawer("Exit Actions", null);
        drawer.setInitialState(1);
        if (version1) {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Exit Action", "Create a new Exit Action", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Exit Bean Action", "Create a new Exit Bean Action", BeanAction.class, (CreationFactory)new ActionModelElementFactory(BeanAction.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Exit Evaluation Action", "Create a new Exit Evaluation Action", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Exit Set", "Create a new Exit Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
        } else {
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Exit Evaluate", "Create a new Exit Evaluate", EvaluateAction.class, (CreationFactory)new ActionModelElementFactory(EvaluateAction.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Exit Set", "Create a new Exit Set", Set.class, (CreationFactory)new ActionModelElementFactory(Set.class, IActionElement.ACTION_TYPE.EXIT_ACTION), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action), dec.getDecoratedImageDescriptor(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif"), action));
            entries.add(combined);
            combined = new CombinedTemplateCreationEntry("Exit Render", "Create a new Exit Render", Action.class, (CreationFactory)new ActionModelElementFactory(Action.class, IActionElement.ACTION_TYPE.ACTION), WebflowUIImages.DESC_OBJS_ACTION, WebflowUIImages.DESC_OBJS_ACTION);
            entries.add(combined);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static class ActionModelElementFactory
    extends SimpleFactory {
        private IActionElement.ACTION_TYPE type;

        public ActionModelElementFactory(Class aClass, IActionElement.ACTION_TYPE type) {
            super(aClass);
            this.type = type;
        }

        public Object getNewObject() {
            IActionElement action = (IActionElement)super.getNewObject();
            action.setType(this.type);
            return action;
        }
    }
}

