/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorInput;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorPaletteFactory;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowImages;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.ExportAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.OpenBeansConfigAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.OpenBeansGraphAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.OpenConfigFileAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.SetAsStartStateAction;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.WebflowContextMenuProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StatePartFactory;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTreeEditPartFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebflowEditor
extends GraphicalEditorWithFlyoutPalette
implements ITabbedPropertySheetPageContributor {
    private IWebflowState diagram;
    private IFile file;
    private boolean isCurrentlySaving = false;
    private IStructuredModel model;
    private OutlinePage outlinePage;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part != WebflowEditor.this) {
                return;
            }
            if (WebflowEditor.this.getEditorInput() instanceof WebflowEditorInput && !((WebflowEditorInput)WebflowEditor.this.getEditorInput()).getFile().exists()) {
                String[] buttons;
                String message;
                String title;
                Shell shell = WebflowEditor.this.getSite().getShell();
                MessageDialog dialog = new MessageDialog(shell, title = "res", null, message = "erer", 3, buttons = new String[]{"Save", "Close"}, 0);
                if (dialog.open() == 0) {
                    if (!WebflowEditor.this.performSaveAs()) {
                        this.partActivated(part);
                    }
                } else {
                    WebflowEditor.this.closeEditor(false);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ResourceTracker resourceListener = new ResourceTracker();
    private PaletteRoot root;
    private boolean savePreviouslyNeeded = false;
    private KeyHandler sharedKeyHandler;
    public static final String EDITOR_ID = "org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditor";

    public WebflowEditor() {
        DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
        defaultEditDomain.setActiveTool((Tool)new ConnectionCreationTool());
        this.setEditDomain(defaultEditDomain);
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScalableRootEditPart root = new ScalableRootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>();
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        root.getZoomManager().setZoomLevels(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.5, 2.0, 2.5, 3.0});
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getActionRegistry().registerAction((IAction)new ExportAction(this));
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        this.getGraphicalViewer().setRootEditPart((RootEditPart)root);
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new StatePartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        WebflowContextMenuProvider provider = new WebflowContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.springframework.ide.eclipse.webflow.ui.graph.contextmenu", (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SetAsStartStateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditPropertiesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ExportAction(this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new OpenConfigFileAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new OpenBeansGraphAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new OpenBeansConfigAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        if (this.getEditorInput() instanceof WebflowEditorInput) {
            ((WebflowEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        if (this.diagram != null) {
            this.diagram = null;
        }
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.isCurrentlySaving = true;
            this.model.aboutToChangeModel();
            IDOMDocument document = ((DOMModelImpl)this.model).getDocument();
            Element root = document.getDocumentElement();
            document.replaceChild((Node)this.diagram.getNode(), (Node)root);
            this.formatElement(monitor);
            this.model.changedModel();
            this.model.save();
            this.getCommandStack().markSaveLocation();
            this.isCurrentlySaving = false;
        }
        catch (Exception exception) {}
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    private void formatElement(IProgressMonitor monitor) {
        FormatProcessorXML formatProcessor = new FormatProcessorXML();
        formatProcessor.setProgressMonitor(monitor);
        formatProcessor.getFormatPreferences().setClearAllBlankLines(true);
        formatProcessor.formatModel(this.model);
        CleanupProcessorXML bla = new CleanupProcessorXML();
        bla.getCleanupPreferences().setCompressEmptyElementTags(true);
        bla.cleanupModel(this.model);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            }
            return this.outlinePage;
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    public GraphicalViewer getGraphViewer() {
        return this.getGraphicalViewer();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = WebflowEditorPaletteFactory.createPalette(WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.diagram));
        }
        return this.root;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void initializeGraphicalViewer() {
        if (this.diagram != null) {
            this.getGraphicalViewer().setContents((Object)this.diagram);
        }
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public boolean performSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((WebflowEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        this.isCurrentlySaving = true;
        if (path == null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    WebflowEditor.this.model.aboutToChangeModel();
                    IDOMDocument document = ((DOMModelImpl)WebflowEditor.this.model).getDocument();
                    Element root = document.getDocumentElement();
                    document.replaceChild((Node)WebflowEditor.this.diagram.getNode(), (Node)root);
                    WebflowEditor.this.formatElement(monitor);
                    WebflowEditor.this.model.changedModel();
                    WebflowEditor.this.model.save((OutputStream)out);
                    file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                    out.close();
                    WebflowEditor.this.getCommandStack().markSaveLocation();
                }
                catch (Exception exception) {}
            }
        };
        IWebflowConfig config = ((WebflowEditorInput)this.getEditorInput()).getConfig();
        IWebflowConfig newConfig = Activator.getModel().getProject(file.getProject()).getConfig(file);
        if (newConfig == null) {
            newConfig = new WebflowConfig(config.getProject());
            newConfig.setBeansConfigs(config.getBeansConfigs());
            newConfig.setResource(file);
            List configs = config.getProject().getConfigs();
            configs.add(newConfig);
            config.getProject().setConfigs(configs);
        } else {
            newConfig.setBeansConfigs(config.getBeansConfigs());
            List configs = config.getProject().getConfigs();
            config.getProject().setConfigs(configs);
        }
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput(new WebflowEditorInput(newConfig));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception exception) {}
        try {
            this.superSetInput(new WebflowEditorInput(newConfig));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception exception) {}
        this.isCurrentlySaving = false;
        return true;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    protected void setInput(IEditorInput input) {
        IFile tempFile;
        if (input instanceof FileEditorInput && WebflowModelUtils.isWebflowConfig((IResource)(tempFile = ((FileEditorInput)input).getFile()))) {
            input = new WebflowEditorInput(WebflowModelUtils.getWebflowConfig((IFile)tempFile));
        }
        if (input instanceof WebflowEditorInput) {
            this.superSetInput(input);
            WebflowEditorInput webflowEditorInput = (WebflowEditorInput)input;
            this.file = webflowEditorInput.getFile();
            this.setPartName(this.file.getName());
            try {
                this.model = null;
                this.model = StructuredModelManager.getModelManager().getExistingModelForEdit(this.file);
                if (this.model == null) {
                    this.model = StructuredModelManager.getModelManager().getModelForEdit(this.file);
                }
                if (this.model != null) {
                    IDOMDocument document = ((DOMModelImpl)this.model).getDocument();
                    this.diagram = new WebflowState(webflowEditorInput.getConfig());
                    IDOMNode root = (IDOMNode)document.getDocumentElement();
                    IDOMNode rootClone = (IDOMNode)root.cloneNode(true);
                    webflowEditorInput.initLineNumbers(root, rootClone);
                    this.diagram.init(rootClone, (IWebflowModelElement)webflowEditorInput.getConfig());
                }
            }
            catch (Exception exception) {}
        } else {
            super.setInput(input);
        }
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    protected void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((WebflowEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((WebflowEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.setPartName(file.getName());
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    private class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private DisposeListener disposeListener;
        private Control outline;
        private Canvas overview;
        private PageBook pageBook;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        private Thumbnail thumbnail;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)WebflowEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new StateTreeEditPartFactory());
            WebflowContextMenuProvider provider = new WebflowContextMenuProvider(this.getViewer(), WebflowEditor.this.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)provider);
            this.getSite().registerContextMenu("org.springframework.ide.eclipse.webflow.ui.graph.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
            this.getViewer().setKeyHandler(WebflowEditor.this.getCommonKeyHandler());
            IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(WebflowImages.DESC_OBJS_OUTLINE);
            this.showOutlineAction.setToolTipText("Show tree outline");
            tbm.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(WebflowImages.DESC_OBJS_OVERVIEW);
            this.showOverviewAction.setToolTipText("Show graphical outline");
            tbm.add(this.showOverviewAction);
            this.showPage(0);
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return WebflowEditor.this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
            }
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void hookOutlineViewer() {
            WebflowEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = WebflowEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "Start_state";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }

        public void initializeOutlineViewer() {
            this.setContents(WebflowEditor.this.diagram);
        }

        protected void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = WebflowEditor.this.getGraphicalViewer().getRootEditPart();
            if (rep instanceof ScalableRootEditPart) {
                ScalableRootEditPart root = (ScalableRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setBorder((Border)new MarginBorder(3));
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                lws.setContents((IFigure)this.thumbnail);
                this.disposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (OutlinePage.this.thumbnail != null) {
                            OutlinePage.this.thumbnail.deactivate();
                            OutlinePage.this.thumbnail = null;
                        }
                    }
                };
                WebflowEditor.this.getEditor().addDisposeListener(this.disposeListener);
            }
        }

        public void setContents(Object contents) {
            this.getViewer().setContents(contents);
        }

        protected void showPage(int id) {
            if (id == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                if (this.thumbnail == null) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        protected void unhookOutlineViewer() {
            WebflowEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (this.disposeListener != null && WebflowEditor.this.getEditor() != null && !WebflowEditor.this.getEditor().isDisposed()) {
                WebflowEditor.this.getEditor().removeDisposeListener(this.disposeListener);
            }
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((WebflowEditorInput)WebflowEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = WebflowEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!WebflowEditor.this.isDirty()) {
                                WebflowEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IWebflowConfig config = ((WebflowEditorInput)WebflowEditor.this.getEditorInput()).getConfig();
                            config.setResource(newFile);
                            List configs = config.getProject().getConfigs();
                            config.getProject().setConfigs(configs);
                            WebflowEditor.this.superSetInput(new WebflowEditorInput(config));
                        }
                    });
                }
            } else if (delta.getKind() == 4) {
                if (!WebflowEditor.this.isDirty() || WebflowEditor.this.isCurrentlySaving) {
                    Display display = WebflowEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IWebflowConfig config = ((WebflowEditorInput)WebflowEditor.this.getEditorInput()).getConfig();
                            WebflowEditor.this.setInput(new WebflowEditorInput(config));
                            WebflowEditor.this.getCommandStack().flush();
                            WebflowEditor.this.initializeGraphicalViewer();
                            if (WebflowEditor.this.outlinePage != null) {
                                WebflowEditor.this.outlinePage.initializeOutlineViewer();
                            }
                        }
                    });
                } else if (WebflowEditor.this.isDirty() && MessageDialog.openQuestion((Shell)org.springframework.ide.eclipse.webflow.ui.editor.Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"File Changed", (String)"The file has been changed on the file system. Do you want to load the changes?")) {
                    Display display = WebflowEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IWebflowConfig config = ((WebflowEditorInput)WebflowEditor.this.getEditorInput()).getConfig();
                            WebflowEditor.this.setInput(new WebflowEditorInput(config));
                            WebflowEditor.this.getCommandStack().flush();
                            WebflowEditor.this.initializeGraphicalViewer();
                            if (WebflowEditor.this.outlinePage != null) {
                                WebflowEditor.this.outlinePage.initializeOutlineViewer();
                            }
                        }
                    });
                }
            }
            return false;
        }
    }
}

