/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching.j9;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.weaving.internal.caching.j9.CachingServicePlugin;
import org.osgi.framework.Bundle;

public class CachingService
implements ICachingService {
    SharedClassURLHelper urlhelper;
    private final Bundle bundle;
    private final ClassLoader classLoader;
    private final String partition;

    public CachingService(ClassLoader classLoader, Bundle bundle, String string) {
        if (CachingServicePlugin.DEBUG) {
            System.out.println("> CachingService.<init>() bundle=" + bundle.getSymbolicName() + ", loader=" + classLoader + ", key='" + string + "'");
        }
        this.bundle = bundle;
        this.classLoader = classLoader;
        this.partition = this.hashNamespace(String.valueOf(string) + bundle.getBundleId() + bundle.getLastModified());
        try {
            this.urlhelper = Shared.getSharedClassHelperFactory().getURLHelper(this.classLoader);
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {
            helperAlreadyDefinedException.printStackTrace();
        }
        if (CachingServicePlugin.DEBUG) {
            System.out.println("< CachingService.<init>() partition='" + this.partition + "', urlhelper=" + this.urlhelper);
        }
    }

    public boolean canCacheGeneratedClasses() {
        return false;
    }

    public CacheEntry findStoredClass(String string, URL uRL, String string2) {
        byte[] byArray = this.urlhelper.findSharedClass(this.partition, uRL, string2);
        if (CachingServicePlugin.DEBUG && byArray != null) {
            System.out.println("- CachingService.findStoredClass() bundle=" + this.bundle.getSymbolicName() + ", name=" + string2 + ", url=" + uRL + ", bytes=" + byArray);
        }
        if (byArray != null) {
            return new CacheEntry(true, byArray);
        }
        return new CacheEntry(false, null);
    }

    public String hashNamespace(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            int n3 = n2 < 0 ? n2 + 256 : n2;
            String string2 = Integer.toHexString(n3);
            while (string2.length() < 2) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
            ++n;
        }
        return new String(stringBuffer);
    }

    public void stop() {
    }

    public boolean storeClass(String string, URL uRL, Class<?> clazz, byte[] byArray) {
        boolean bl = this.urlhelper.storeSharedClass(this.partition, uRL, clazz);
        if (CachingServicePlugin.DEBUG && bl) {
            System.out.println("- CachingService.storeClass() bundle=" + this.bundle.getSymbolicName() + ", clazz=" + clazz + ", url=" + uRL);
        }
        return bl;
    }

    public boolean storeClassAndGeneratedClasses(String string, URL uRL, Class<?> clazz, byte[] byArray, Map<String, byte[]> map) {
        return false;
    }
}

