/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanMethodOverride;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.SpringProject;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanConstructorArgumentHelper;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanPropertyHelper;
import org.springframework.util.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHelper
extends Bean
implements IBean {
    private final IDOMNode beanNode;
    private final IFile file;
    private final SpringProject springProject;

    public BeanHelper(IDOMNode beanNode, IFile file, IProject project) {
        super((IModelElement)new SpringProject(SpringCore.getModel(), project), new BeanDefinitionHolder(BeanHelper.getBeanDefinition(beanNode), BeanHelper.getElementName(beanNode)));
        this.beanNode = beanNode;
        this.file = file;
        this.springProject = new SpringProject(SpringCore.getModel(), project);
        AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)this.getBeanDefinition();
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        Set<IBeanConstructorArgument> constructorArgs = this.getConstructorArguments();
        int index = 0;
        for (IBeanConstructorArgument constructorArg : constructorArgs) {
            constructorArgumentValues.addIndexedArgumentValue(index, constructorArg.getValue());
            ++index;
        }
        beanDefinition.setConstructorArgumentValues(constructorArgumentValues);
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        Collection properties = this.getProperties();
        for (IBeanProperty property : properties) {
            propertyValues.add(property.getElementName(), property.getValue());
        }
        beanDefinition.setPropertyValues(propertyValues);
        this.setElementSourceLocation(new IModelSourceLocation(){

            public int getEndLine() {
                return 0;
            }

            public Resource getResource() {
                return new FileResource(BeanHelper.this.file);
            }

            public int getStartLine() {
                return 0;
            }
        });
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            visitor.visit((IModelElement)this, monitor);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String[] getAliases() {
        return null;
    }

    public String getClassName() {
        return BeanHelper.getClassName(this.beanNode);
    }

    public Set<IBeanConstructorArgument> getConstructorArguments() {
        String name;
        String localName;
        Node child;
        HashSet<IBeanConstructorArgument> arguments = new HashSet<IBeanConstructorArgument>();
        NodeList childNodes = this.beanNode.getChildNodes();
        NamedNodeMap attrs = this.beanNode.getAttributes();
        int counter = 0;
        int i = 0;
        while (i < childNodes.getLength()) {
            child = childNodes.item(i);
            localName = child.getLocalName();
            if (localName != null && localName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                name = null;
                NamedNodeMap attributes = child.getAttributes();
                Node attribute = attributes.getNamedItem(BeansSchemaConstants.ATTR_NAME);
                if (attribute != null) {
                    name = attribute.getNodeValue();
                }
                arguments.add(new BeanConstructorArgumentHelper(counter, name, (IDOMNode)child, this.file, this));
                ++counter;
            }
            ++i;
        }
        if (counter == 0 && arguments.isEmpty() && attrs != null) {
            i = 0;
            while (i < attrs.getLength()) {
                child = attrs.item(i);
                if ("http://www.springframework.org/schema/c".equals(child.getNamespaceURI()) && (localName = child.getLocalName()) != null) {
                    name = null;
                    name = localName.endsWith("-ref") ? localName.substring(0, localName.length() - 4) : localName;
                    arguments.add(new BeanConstructorArgumentHelper(counter, name, (IDOMNode)child, this.file, this));
                    ++counter;
                }
                ++i;
            }
        }
        return arguments;
    }

    public IModelElement[] getElementChildren() {
        return this.getConstructorArguments().toArray(new IModelElement[0]);
    }

    public int getElementEndLine() {
        return 0;
    }

    public String getElementName() {
        return BeanHelper.getElementName(this.beanNode);
    }

    public IResource getElementResource() {
        return this.file;
    }

    public IResourceModelElement getElementSourceElement() {
        return this.springProject;
    }

    public int getElementStartLine() {
        return 0;
    }

    public int getElementType() {
        return 8;
    }

    public Set<IBeanMethodOverride> getMethodOverrides() {
        return new HashSet<IBeanMethodOverride>();
    }

    public String getParentName() {
        return this.getBeanDefinition().getParentName();
    }

    public Set<IBeanProperty> getProperties() {
        HashSet<IBeanProperty> properties = new HashSet<IBeanProperty>();
        NodeList childNodes = this.beanNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            String localName = child.getLocalName();
            if (localName != null && localName.equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                properties.add(new BeanPropertyHelper((IDOMNode)child, this.file, this));
            }
            ++i;
        }
        return properties;
    }

    public IBeanProperty getProperty(String name) {
        Collection properties = this.getProperties();
        for (IBeanProperty property : properties) {
            if (name == null || !name.equals(property.getElementName())) continue;
            return property;
        }
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isChildBean() {
        return this.getParentName() != null;
    }

    public boolean isElementArchived() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isFactory() {
        return false;
    }

    public boolean isGeneratedElementName() {
        return false;
    }

    public boolean isInfrastructure() {
        return false;
    }

    public boolean isInnerBean() {
        String localName;
        Node parentNode = this.beanNode.getParentNode();
        return parentNode == null || (localName = parentNode.getLocalName()) == null || !localName.equals(BeansSchemaConstants.ELEM_BEANS);
    }

    public boolean isLazyInit() {
        return false;
    }

    public boolean isRootBean() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    private static BeanDefinition getBeanDefinition(IDOMNode node) {
        RootBeanDefinition bd = null;
        if (BeansEditorUtils.getAttribute((Node)node, (String)"parent") != null) {
            bd = new ChildBeanDefinition(BeansEditorUtils.getAttribute((Node)node, (String)"parent"));
            bd.setBeanClassName(BeanHelper.getClassName(node));
        } else {
            bd = new RootBeanDefinition(BeanHelper.getClassName(node));
        }
        String factoryBean = BeansEditorUtils.getAttribute((Node)node, (String)"factory-bean");
        String factoryMethod = BeansEditorUtils.getAttribute((Node)node, (String)"factory-method");
        String autowireValue = BeansEditorUtils.getAttribute((Node)node, (String)"autowire");
        if (StringUtils.hasText((String)factoryBean)) {
            bd.setFactoryBeanName(factoryBean);
        }
        if (StringUtils.hasText((String)factoryMethod)) {
            bd.setFactoryMethodName(factoryMethod);
        }
        if (StringUtils.hasText((String)autowireValue)) {
            bd.setAutowireMode(BeanHelper.getAutowireMode((Node)node, autowireValue));
        }
        return bd;
    }

    private static int getAutowireMode(Node node, String autowireValue) {
        String defaultAutowire;
        Node parent;
        String att = autowireValue;
        if ("default".equals(att) && (parent = node.getParentNode()) != null && StringUtils.hasText((String)(defaultAutowire = BeansEditorUtils.getAttribute((Node)parent, (String)"default-autowire")))) {
            att = defaultAutowire;
        }
        int autowire = 0;
        if ("byName".equals(att)) {
            autowire = 1;
        } else if ("byType".equals(att)) {
            autowire = 2;
        } else if ("constructor".equals(att)) {
            autowire = 3;
        } else if ("autodetect".equals(att)) {
            autowire = 4;
        }
        return autowire;
    }

    private static String getClassName(IDOMNode node) {
        return BeansEditorUtils.getClassNameForBean((Node)node);
    }

    protected static String getElementName(IDOMNode n) {
        NamedNodeMap attributes = n.getAttributes();
        if (attributes != null) {
            Node id = attributes.getNamedItem(BeansSchemaConstants.ATTR_NAME);
            if (id != null) {
                return id.getNodeValue();
            }
            id = attributes.getNamedItem(BeansSchemaConstants.ATTR_ID);
            if (id != null) {
                return id.getNodeValue();
            }
        }
        return "beanid";
    }
}

