/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanAlias;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanAliasRule;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeansValidationContextHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeanAliasValidator
extends BeanValidator {
    public boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, IFile file, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator, String text) {
        IProject project;
        ValidationRuleDefinition ruleDefinition;
        Node aliasNode;
        String beanName = null;
        String alias = null;
        NamedNodeMap attributes = parent.getAttributes();
        Node nameNode = attributes.getNamedItem(BeansSchemaConstants.ATTR_NAME);
        if (nameNode != null) {
            beanName = nameNode.getNodeValue();
        }
        if ((aliasNode = attributes.getNamedItem(BeansSchemaConstants.ATTR_ALIAS)) != null) {
            alias = aliasNode.getNodeValue();
        }
        AliasDefinition definition = new AliasDefinition(beanName, alias);
        IBeanAlias beanAlias = null;
        if (alias != null) {
            beanAlias = config.getAlias(alias);
        }
        if (beanAlias == null) {
            beanAlias = new BeanAlias(config, definition);
        }
        BeanAliasRule aliasRule = (BeanAliasRule)((ruleDefinition = this.getValidationRule(project = file.getProject(), BeanAliasRule.class)) != null ? ruleDefinition.getRule() : null);
        BeansValidationContextHelper context = new BeansValidationContextHelper(attribute, parent, contextElement, project, reporter, validator, QuickfixProcessorFactory.ALIAS, false, reportError, config);
        if (aliasRule != null) {
            aliasRule.validate(beanAlias, (IBeansValidationContext)context, null);
        }
        return context.getErrorFound();
    }
}

