/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;

public class RemoveConstructorParamQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final int numAdditionalParams;
    private final IMethod constructor;
    private final String label;
    private final IJavaProject javaProject;

    public RemoveConstructorParamQuickFixProposal(int offset, int length, boolean missingEndQuote, int numAdditionalParams, IMethod constructor, String label, IJavaProject javaProject) {
        super(offset, length, missingEndQuote);
        this.numAdditionalParams = numAdditionalParams;
        this.constructor = constructor;
        this.label = label;
        this.javaProject = javaProject;
    }

    public void applyQuickFix(IDocument document) {
        int numParams = this.constructor.getNumberOfParameters();
        Object[] changeDesc = QuickfixReflectionUtils.createChangeDescriptionArray(numParams);
        int i = numParams - 1;
        while (i >= numParams - this.numAdditionalParams) {
            changeDesc[i] = QuickfixReflectionUtils.createRemoveDescription();
            --i;
        }
        ICompilationUnit targetCU = this.constructor.getCompilationUnit();
        String[] paramTypes = new String[numParams];
        int i2 = 0;
        while (i2 < numParams) {
            paramTypes[i2] = "Object";
            ++i2;
        }
        IMethodBinding methodBinding = QuickfixUtils.getMethodBinding(this.javaProject, this.constructor);
        if (methodBinding != null) {
            ClassInstanceCreation invocationNode = QuickfixUtils.getMockConstructorInvocation(this.constructor.getDeclaringType().getFullyQualifiedName(), paramTypes);
            Object proposal = QuickfixReflectionUtils.createChangeMethodSignatureProposal(this.label, targetCU, invocationNode, methodBinding, changeDesc, 5, this.getImage());
            QuickfixReflectionUtils.applyProposal(proposal, document);
        }
    }

    public String getDisplayString() {
        String params = "";
        int numParams = this.constructor.getNumberOfParameters();
        IMethodBinding methodBinding = QuickfixUtils.getMethodBinding(this.javaProject, this.constructor);
        ITypeBinding[] typeParameters = methodBinding.getParameterTypes();
        int i = numParams - this.numAdditionalParams;
        while (i < numParams) {
            if (params.length() > 0) {
                params = String.valueOf(params) + ", ";
            }
            params = String.valueOf(params) + "'" + ASTResolving.getTypeSignature((ITypeBinding)typeParameters[i]) + "'";
            ++i;
        }
        return String.valueOf(this.label) + ": Remove parameter " + params;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.remove_correction.gif");
    }
}

