/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewClassQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private String className;
    private String packageName;
    private IPackageFragmentRoot sourceRoot;
    private final Set<String> properties;
    private final int numConstructorArgs;
    private final IJavaProject javaProject;
    private final boolean allowUserChanges;
    private IType enclosingType;

    public CreateNewClassQuickFixProposal(int offset, int length, String text, boolean missingEndQuote, IJavaProject javaProject, Set<String> properties, int numConstructorArgs) {
        this(offset, length, text, missingEndQuote, javaProject, properties, numConstructorArgs, true);
    }

    public CreateNewClassQuickFixProposal(int offset, int length, String text, boolean missingEndQuote, IJavaProject javaProject, Set<String> properties, int numConstructorArgs, boolean allowUserChanges) {
        block7: {
            int packageEnd;
            super(offset, length, missingEndQuote);
            this.properties = properties;
            this.numConstructorArgs = numConstructorArgs;
            this.javaProject = javaProject;
            this.allowUserChanges = allowUserChanges;
            int classNameOffset = text.lastIndexOf("$");
            if (classNameOffset >= 0) {
                String enclosingClassName = text.substring(0, classNameOffset);
                this.enclosingType = JdtUtils.getJavaType((IProject)javaProject.getProject(), (String)enclosingClassName);
                packageEnd = enclosingClassName.lastIndexOf(".");
            } else {
                packageEnd = classNameOffset = text.lastIndexOf(".");
            }
            this.className = classNameOffset < 0 ? text : text.substring(classNameOffset + 1);
            this.packageName = packageEnd >= 0 ? text.substring(0, packageEnd) : "";
            String packageFragmentName = null;
            if (this.enclosingType != null) {
                packageFragmentName = this.enclosingType.getPackageFragment().getElementName();
            }
            try {
                IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                if (allPackageFragmentRoots == null || allPackageFragmentRoots.length <= 0) break block7;
                IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
                int n = allPackageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (!(packageFragmentRoot instanceof JarPackageFragmentRoot || packageFragmentName != null && packageFragmentRoot.getPackageFragment(packageFragmentName) == null)) {
                        this.sourceRoot = packageFragmentRoot;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private IJavaElement applyQuickFix() {
        IPackageFragment packageFragment = null;
        if (this.packageName != null && this.packageName.length() > 0) {
            packageFragment = this.findPackageFragment(this.packageName);
        }
        NewClassWizardPage page = new NewClassWizardPage();
        page.setTypeName(this.className, false);
        if (packageFragment != null) {
            page.setPackageFragment(packageFragment, true);
        } else if (this.sourceRoot != null) {
            page.setPackageFragment(this.sourceRoot.getPackageFragment(this.packageName), true);
        }
        if (this.sourceRoot != null) {
            page.setPackageFragmentRoot(this.sourceRoot, true);
        }
        if (this.enclosingType != null) {
            page.setEnclosingType(this.enclosingType, false);
            page.setEnclosingTypeSelection(true, false);
        }
        NewClassCreationWizard wizard = new NewClassCreationWizard(page, true);
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("New Class");
        if (this.allowUserChanges) {
            dialog.setBlockOnOpen(true);
            if (dialog.open() != 0) {
                return null;
            }
        } else {
            wizard.performFinish();
        }
        return wizard.getCreatedElement();
    }

    @Override
    public void applyQuickFix(IDocument document) {
        IJavaElement createdElement;
        if (this.packageName == null) {
            try {
                String text = document.get(this.getOffset(), this.getLength());
                int lastDotPos = text.lastIndexOf(".");
                this.packageName = lastDotPos < 0 ? "" : text.substring(0, lastDotPos);
            }
            catch (BadLocationException badLocationException) {}
        }
        if ((createdElement = this.applyQuickFix()) instanceof IType) {
            IType targetType = (IType)createdElement;
            this.createProperties(document, targetType);
            ArrayList<String> constructorArgClassNames = new ArrayList<String>();
            int i = 0;
            while (i < this.numConstructorArgs) {
                constructorArgClassNames.add("Object");
                ++i;
            }
            QuickfixUtils.createConstructor(document, targetType, constructorArgClassNames, this.javaProject);
        }
    }

    private void createProperties(IDocument document, IType targetType) {
        ICompilationUnit cu = targetType.getCompilationUnit();
        if (cu == null) {
            return;
        }
        for (String property : this.properties) {
            this.createProperty(property, cu, document, targetType);
        }
    }

    private void createProperty(String property, ICompilationUnit cu, IDocument document, IType targetType) {
        MethodInvocation expr = QuickfixUtils.getMockMethodInvocation(property, new String[0], "void", false);
        SimpleName simpleName = expr.getName();
        ITypeBinding typeBinding = QuickfixUtils.getTargetTypeBinding(this.javaProject, targetType);
        Object fieldProposal = QuickfixReflectionUtils.createNewFieldProposal(property, cu, simpleName, typeBinding, 0, null);
        QuickfixReflectionUtils.applyProposal(fieldProposal, document);
        String methodName = "set" + StringUtils.capitalize((String)property);
        MethodInvocation invocationNode = QuickfixUtils.getMockMethodInvocation(methodName, new String[]{"Object"}, "void", false);
        List<Expression> arguments = QuickfixUtils.getArguments(invocationNode);
        Object setterProposal = QuickfixReflectionUtils.createNewMethodProposal(methodName, cu, (ASTNode)invocationNode, arguments, typeBinding, 0, null);
        QuickfixReflectionUtils.applyProposal(setterProposal, document);
    }

    private IPackageFragment findPackageFragment(String packageName) {
        final ArrayList results = new ArrayList();
        SearchRequestor collector = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IPackageFragment packageFragment;
                Object element = match.getElement();
                if (element instanceof IPackageFragment && !(packageFragment = (IPackageFragment)element).isReadOnly()) {
                    results.add(packageFragment);
                }
            }
        };
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)packageName, (int)2, (int)3, (int)0);
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), collector, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        if (results.size() > 0) {
            return (IPackageFragment)results.get(0);
        }
        return null;
    }

    public String getDisplayString() {
        return "Create class '" + this.className + "'";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");
    }

    @Override
    public void run(IMarker marker) {
        this.applyQuickFix();
    }
}

