/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.NameSuggestionComparator;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewClassQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RenameToSimilarNameQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAttributeQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final Set<String> propertyNames;
    private final int numConstructorArgs;
    private final IJavaProject javaProject;

    public ClassAttributeQuickAssistProcessor(int offset, int length, String text, IProject project, boolean missingEndQuote, Set<String> propertyNames, int numConstructorArgs) {
        super(offset, length, text, missingEndQuote);
        this.propertyNames = propertyNames;
        this.numConstructorArgs = numConstructorArgs;
        this.javaProject = JavaCore.create((IProject)project).getJavaProject();
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<BeanAttributeQuickFixProposal> proposals = new ArrayList<BeanAttributeQuickFixProposal>();
        int lastDotPos = this.text.lastIndexOf(".");
        String className = lastDotPos < 0 ? this.text : this.text.substring(lastDotPos + 1);
        try {
            IPackageFragmentRoot[] fragmentRoots;
            SimilarCUFindingVisitor visitor = new SimilarCUFindingVisitor(className);
            IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = this.javaProject.getAllPackageFragmentRoots();
            int n = fragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot instanceof JarPackageFragmentRoot) {
                    visitor.visitJar((JarPackageFragmentRoot)fragmentRoot);
                }
                if ((resource = fragmentRoot.getResource()) != null) {
                    resource.accept((IResourceVisitor)visitor);
                }
                ++n2;
            }
            List<String> suggestedClassNames = visitor.getSuggestedClassNames();
            for (String suggestedClassName : suggestedClassNames) {
                proposals.add(new RenameToSimilarNameQuickFixProposal(suggestedClassName, this.offset, this.length, this.missingEndQuote));
            }
            proposals.add(new CreateNewClassQuickFixProposal(this.offset, this.length, this.text, this.missingEndQuote, this.javaProject, this.propertyNames, this.numConstructorArgs));
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        catch (CoreException coreException) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Cound not compute proposals."));
            return new ICompletionProposal[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimilarCUFindingVisitor
    implements IResourceVisitor {
        private final Set<String> suggestedClassNames = new HashSet<String>();
        private final String toMatch;

        private SimilarCUFindingVisitor(String toMatch) {
            this.toMatch = toMatch;
        }

        public List<String> getSuggestedClassNames() {
            ArrayList<String> result = new ArrayList<String>(this.suggestedClassNames);
            Collections.sort(result, new NameSuggestionComparator(this.toMatch));
            return result;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension = file.getFullPath().getFileExtension();
                if (fileExtension == null) {
                    return false;
                }
                if (fileExtension.equals("java")) {
                    ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
                    if (cu instanceof CompilationUnit) {
                        IType[] types;
                        CompilationUnit c = (CompilationUnit)cu;
                        IType[] iTypeArray = types = c.getAllTypes();
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            if (NameMatcher.isSimilarName((String)type.getElementName(), (String)this.toMatch)) {
                                this.suggestedClassNames.add(type.getFullyQualifiedName());
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
                if (fileExtension.equals("class")) {
                    IClassFile classFile = JavaCore.createClassFileFrom((IFile)file);
                    IType type = classFile.getType();
                    if (type != null && NameMatcher.isSimilarName((String)type.getElementName(), (String)this.toMatch)) {
                        this.suggestedClassNames.add(type.getFullyQualifiedName());
                    }
                    return false;
                }
                return true;
            }
            return true;
        }

        public void visitJar(JarPackageFragmentRoot jarRoot) throws CoreException {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = jarRoot.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof PackageFragment) {
                    this.visitPackageFragment((PackageFragment)child);
                }
                ++n2;
            }
        }

        public void visitPackageFragment(PackageFragment fragment) throws JavaModelException {
            IJavaElement[] grandChildren;
            IJavaElement[] iJavaElementArray = grandChildren = fragment.getChildren();
            int n = grandChildren.length;
            int n2 = 0;
            while (n2 < n) {
                ClassFile classFile;
                IType type;
                IJavaElement grandChild = iJavaElementArray[n2];
                if (grandChild instanceof ClassFile && NameMatcher.isSimilarName((String)(type = (classFile = (ClassFile)grandChild).getType()).getElementName(), (String)this.toMatch)) {
                    this.suggestedClassNames.add(type.getFullyQualifiedName());
                }
                ++n2;
            }
        }
    }
}

