/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowireDependencyProvider;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProposalCalculatorUtil {
    private static Class<?>[] KNOWN_REQUEST_MAPPING_PARAM_TYPE = new Class[]{InputStream.class, OutputStream.class, Reader.class, Writer.class, Principal.class, Locale.class, HttpServletRequest.class, HttpServletResponse.class, HttpSession.class};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsImport(ICompilationUnit cu, String importName) {
        String importPackageName = importName;
        int index = importName.lastIndexOf(".");
        if (index > 0) {
            importPackageName = importName.substring(0, index);
        }
        try {
            IImportDeclaration[] importDecls;
            IPackageDeclaration[] packageDecls;
            IPackageDeclaration[] iPackageDeclarationArray = packageDecls = cu.getPackageDeclarations();
            int n = packageDecls.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageDeclaration packageDecl = iPackageDeclarationArray[n2];
                String packageName = packageDecl.getElementName();
                if (packageName.equals(importPackageName)) {
                    return true;
                }
                ++n2;
            }
            IImportDeclaration[] iImportDeclarationArray = importDecls = cu.getImports();
            int n3 = importDecls.length;
            n = 0;
            while (n < n3) {
                IImportDeclaration importDecl = iImportDeclarationArray[n];
                String importElementName = importDecl.getElementName();
                index = importElementName.lastIndexOf(".");
                String importElementPackageName = importElementName;
                if (index > 0) {
                    importElementPackageName = importElementName.substring(0, index);
                }
                if (importElementName.endsWith("*") ? importPackageName.equals(importElementPackageName) : importName.equals(importElementName)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        return false;
    }

    public static Set<Annotation> findAnnotations(String annotation, ASTNode node) {
        AnnotationFinder finder = new AnnotationFinder(annotation);
        node.accept((ASTVisitor)finder);
        return finder.getAnnotations();
    }

    public static Set<Annotation> findAnnotations(String annotation, int invocationOffset, ASTNode node) {
        AnnotationFinder finder = new AnnotationFinder(annotation, invocationOffset);
        node.accept((ASTVisitor)finder);
        return finder.getAnnotations();
    }

    public static boolean hasAnnotationInParameters(SourceMethod method, String annotationName) {
        try {
            if (method.getSource() != null) {
                return method.getSource().contains(String.valueOf('@') + annotationName);
            }
            return false;
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnnotationOnType(ICompilationUnit cu, String annotationName) {
        try {
            IType[] allTypes;
            IType[] iTypeArray = allTypes = cu.getAllTypes();
            int n = allTypes.length;
            int n2 = 0;
            block2: while (true) {
                IAnnotation[] annotations;
                if (n2 >= n) {
                    return false;
                }
                IType type = iTypeArray[n2];
                IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    IAnnotation annotation = iAnnotationArray[n4];
                    if (annotationName.equals(annotation.getElementName())) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnnotation(IAnnotatable element, String annotationName) {
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = element.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotationName.equals(annotation.getElementName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        return false;
    }

    public static ValidationProblem findProblem(BodyDeclaration declToMatch, String problemType, ICompilationUnit cu, String typeNameToMatch) {
        IBeansModel model = BeansCorePlugin.getModel();
        IBeansProject springProject = model.getProject(cu.getJavaProject().getProject());
        Set configs = springProject.getConfigs();
        for (IBeansConfig config : configs) {
            AutowireDependencyProvider provider = new AutowireDependencyProvider((IBeansModelElement)config, (IBeansModelElement)config);
            provider.resolveAutowiredDependencies();
            List problems = provider.getValidationProblems();
            for (ValidationProblem problem : problems) {
                ValidationProblemAttribute[] problemAttributes = problem.getAttributes();
                boolean matched = false;
                BodyDeclaration problemDecl = null;
                String typeName = null;
                ValidationProblemAttribute[] validationProblemAttributeArray = problemAttributes;
                int n = problemAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidationProblemAttribute problemAttribute = validationProblemAttributeArray[n2];
                    if ("AUTOWIRE_PROBLEM".equals(problemAttribute.getKey())) {
                        if (problemType.equals(problemAttribute.getValue())) {
                            matched = true;
                        }
                    } else if ("JAVA_HANDLE".equals(problemAttribute.getKey())) {
                        problemDecl = ProposalCalculatorUtil.getBodyDeclaration(JavaCore.create((String)((String)problemAttribute.getValue())));
                    } else if ("BEAN_TYPE".equals(problemAttribute.getKey())) {
                        typeName = (String)problemAttribute.getValue();
                    }
                    ++n2;
                }
                if (!matched || problemDecl == null || !problemDecl.equals((Object)declToMatch) || typeNameToMatch != null && (typeName == null || !typeName.equals(typeNameToMatch))) continue;
                return problem;
            }
        }
        return null;
    }

    public static Set<String> getMatchingBeans(IInvocationContext context, ITypeBinding typeBinding) {
        IProject project = null;
        try {
            project = context.getCompilationUnit().getUnderlyingResource().getProject();
        }
        catch (JavaModelException javaModelException) {
            return new HashSet<String>();
        }
        String typeName = typeBinding.getQualifiedName();
        IBeansProject springProject = BeansCorePlugin.getModel().getProject(project);
        return ProposalCalculatorUtil.getMatchingBeans(typeName, springProject, null);
    }

    public static Set<String> getMatchingBeans(IInvocationContext context, ITypeBinding typeBinding, String qualifier) {
        IProject project = null;
        try {
            project = context.getCompilationUnit().getUnderlyingResource().getProject();
        }
        catch (JavaModelException javaModelException) {
            return new HashSet<String>();
        }
        String typeName = typeBinding.getQualifiedName();
        IBeansProject springProject = BeansCorePlugin.getModel().getProject(project);
        return ProposalCalculatorUtil.getMatchingBeans(typeName, springProject, qualifier);
    }

    public static Set<String> getMatchingBeans(JavaContentAssistInvocationContext context, ITypeBinding type) {
        IBeansProject springProject = BeansCorePlugin.getModel().getProject(context.getProject().getProject());
        String typeName = type.getQualifiedName();
        return ProposalCalculatorUtil.getMatchingBeans(typeName, springProject, null);
    }

    public static Set<String> getMatchingBeans(String typeName, IBeansProject springProject, String qualifier) {
        HashSet<String> matchingBeans = new HashSet<String>();
        Class<?> clazz = null;
        ClassLoader classLoader = JdtUtils.getProjectClassLoaderSupport((IProject)springProject.getProject(), (ClassLoader)BeansCorePlugin.getClassLoader()).getProjectClassLoader();
        try {
            clazz = classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return matchingBeans;
        }
        Set beans = BeansModelUtils.getBeans((IModelElement)springProject);
        for (IBean bean : beans) {
            String beanClassName = ValidationRuleUtils.getBeanClassName((IBean)bean);
            if (beanClassName == null) continue;
            try {
                Class<?> beanClass = classLoader.loadClass(beanClassName);
                if (!clazz.isAssignableFrom(beanClass) || qualifier != null && !qualifier.equals(bean.getElementName())) continue;
                matchingBeans.add(bean.getElementName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return matchingBeans;
    }

    public static String getPathVariableName(SingleVariableDeclaration param) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("PathVariable", (ASTNode)param);
        for (Annotation annotation : annotations) {
            if (annotation.isMarkerAnnotation()) {
                return param.getName().getFullyQualifiedName();
            }
            if (annotation.isSingleMemberAnnotation()) {
                Expression value = ((SingleMemberAnnotation)annotation).getValue();
                if (!(value instanceof StringLiteral)) continue;
                return ((StringLiteral)value).getLiteralValue();
            }
            if (!annotation.isNormalAnnotation()) continue;
            NormalAnnotation nAnnotation = (NormalAnnotation)annotation;
            List valuePairs = nAnnotation.values();
            for (MemberValuePair valuePair : valuePairs) {
                Expression value;
                if (!"value".equals(valuePair.getName().getIdentifier()) || !((value = valuePair.getValue()) instanceof StringLiteral)) continue;
                return ((StringLiteral)value).getLiteralValue();
            }
        }
        return null;
    }

    public static MemberValuePair getRequiredMemberValuePair(BodyDeclaration decl) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("Autowired", (ASTNode)decl);
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof NormalAnnotation)) continue;
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            List values = normalAnnotation.values();
            for (MemberValuePair valuePair : values) {
                if (!"required".equals(valuePair.getName().toString())) continue;
                return valuePair;
            }
        }
        return null;
    }

    public static String getTypeName(Type type) {
        StringBuilder result = new StringBuilder();
        if (type.isArrayType()) {
            result.append(ProposalCalculatorUtil.getTypeName(((ArrayType)type).getElementType()));
            result.append("[]");
        } else if (type.isParameterizedType()) {
            ParameterizedType pType = (ParameterizedType)type;
            result.append(ProposalCalculatorUtil.getTypeName(pType.getType()));
            List typeArguments = pType.typeArguments();
            int i = 0;
            while (i < typeArguments.size()) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(ProposalCalculatorUtil.getTypeName((Type)typeArguments.get(i)));
                ++i;
            }
        } else if (type.isPrimitiveType()) {
            result.append(((PrimitiveType)type).getPrimitiveTypeCode().toString());
        } else if (type.isQualifiedType()) {
            QualifiedType qType = (QualifiedType)type;
            Type qualifier = qType.getQualifier();
            if (qualifier != null) {
                result.append(ProposalCalculatorUtil.getTypeName(qualifier));
                result.append(".");
            }
            result.append(qType.getName().getFullyQualifiedName());
        } else if (type.isSimpleType()) {
            result.append(((SimpleType)type).getName().getFullyQualifiedName());
        } else if (type.isWildcardType()) {
            WildcardType wType = (WildcardType)type;
            result.append("? ");
            if (wType.isUpperBound()) {
                result.append("extends ");
            } else {
                result.append("super ");
            }
            result.append(ProposalCalculatorUtil.getTypeName(wType.getBound()));
        }
        return result.toString();
    }

    public static List<UriTemplateVariable> getUriTemplatVariables(Annotation annotation) {
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation sAnnotation = (SingleMemberAnnotation)annotation;
            return ProposalCalculatorUtil.getUriTemplateVariables(sAnnotation.getValue());
        }
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation nAnnotation = (NormalAnnotation)annotation;
            List pairs = nAnnotation.values();
            for (MemberValuePair pair : pairs) {
                if (!"value".equals(pair.getName().getFullyQualifiedName())) continue;
                return ProposalCalculatorUtil.getUriTemplateVariables(pair.getValue());
            }
        }
        return new ArrayList<UriTemplateVariable>();
    }

    public static boolean hasAnnotation(String annotation, ASTNode node) {
        AnnotationFinder finder = new AnnotationFinder(annotation);
        node.accept((ASTVisitor)finder);
        Set<Annotation> annotations = finder.getAnnotations();
        return !annotations.isEmpty();
    }

    public static boolean hasProblem(BodyDeclaration declToMatch, String problemType, ICompilationUnit cu) {
        return ProposalCalculatorUtil.findProblem(declToMatch, problemType, cu, null) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isKnownRequestMappingParamType(IProject project, ITypeBinding typeBinding) {
        String typeName = typeBinding.getQualifiedName();
        ClassLoader classLoader = JdtUtils.getProjectClassLoaderSupport((IProject)project, (ClassLoader)BeansCorePlugin.getClassLoader()).getProjectClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(typeName);
            Class<?>[] classArray = KNOWN_REQUEST_MAPPING_PARAM_TYPE;
            int n = KNOWN_REQUEST_MAPPING_PARAM_TYPE.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Class<?> knownClass = classArray[n2];
                Class<?> loadedClass = classLoader.loadClass(knownClass.getCanonicalName());
                if (loadedClass.isAssignableFrom(clazz)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    private static BodyDeclaration getBodyDeclaration(IJavaElement element) {
        try {
            ISourceRange sourceRange;
            IMember member;
            ICompilationUnit compilationUnit;
            AssistContext assistContext;
            ASTNode node;
            if (element instanceof IMember && (node = (assistContext = new AssistContext(compilationUnit = (member = (IMember)element).getCompilationUnit(), null, (sourceRange = member.getSourceRange()).getOffset(), sourceRange.getLength())).getCoveringNode()) instanceof BodyDeclaration) {
                return (BodyDeclaration)node;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private static List<UriTemplateVariable> getUriTemplateVariables(Expression expression) {
        ArrayList<UriTemplateVariable> variables = new ArrayList<UriTemplateVariable>();
        if (expression instanceof StringLiteral) {
            StringLiteral literal = (StringLiteral)expression;
            String uriTemplate = literal.getLiteralValue();
            int offset = 1;
            while (uriTemplate.length() > 0) {
                int index = uriTemplate.indexOf("{");
                if (index < 0) break;
                uriTemplate = uriTemplate.substring(index + 1);
                offset += index + 1;
                index = uriTemplate.indexOf(":");
                if (index < 0 && (index = uriTemplate.indexOf("}")) < 0) break;
                variables.add(new UriTemplateVariable(uriTemplate.substring(0, index), offset, (ASTNode)literal));
                uriTemplate = uriTemplate.substring(index + 1);
                offset += index + 1;
            }
        }
        return variables;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationFinder
    extends ASTVisitor {
        Set<Annotation> annotations = new HashSet<Annotation>();
        private final String annotationToMatch;
        private final int invocationOffset;
        private boolean isTypeDecl;

        public AnnotationFinder(String annotationToMatch) {
            this.annotationToMatch = annotationToMatch;
            this.invocationOffset = -1;
        }

        public AnnotationFinder(String annotationToMatch, int invocationOffset) {
            this.annotationToMatch = annotationToMatch;
            this.invocationOffset = invocationOffset;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean visit(FieldDeclaration node) {
            if (this.isTypeDecl) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(MarkerAnnotation node) {
            if (this.matches((Annotation)node)) {
                this.annotations.add((Annotation)node);
            }
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.isTypeDecl) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(NormalAnnotation node) {
            if (this.matches((Annotation)node)) {
                this.annotations.add((Annotation)node);
            }
            return false;
        }

        public boolean visit(SingleMemberAnnotation node) {
            if (this.matches((Annotation)node)) {
                this.annotations.add((Annotation)node);
            }
            return false;
        }

        public boolean visit(TypeDeclaration typeDecl) {
            this.isTypeDecl = true;
            return super.visit(typeDecl);
        }

        private boolean matches(Annotation annotation) {
            Name typeName = annotation.getTypeName();
            if (typeName != null) {
                int startPos;
                if (this.invocationOffset >= 0 && ((startPos = annotation.getStartPosition()) > this.invocationOffset || startPos + annotation.getLength() < this.invocationOffset)) {
                    return false;
                }
                return this.annotationToMatch == null || typeName.toString().equals(this.annotationToMatch);
            }
            return false;
        }
    }
}

