/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.MarkerResolutionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;
import org.springframework.web.bind.annotation.PathVariable;

public class AddPathVariableParameterCompletionProposal
extends MarkerResolutionProposal {
    private final UriTemplateVariable variable;
    private final MethodDeclaration methodDecl;

    public AddPathVariableParameterCompletionProposal(UriTemplateVariable variable, MethodDeclaration methodDecl, ICompilationUnit cu) {
        super(AddPathVariableParameterCompletionProposal.getDisplayName(variable), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.variable = variable;
        this.methodDecl = methodDecl;
    }

    private static String getDisplayName(UriTemplateVariable variable) {
        return "Create parameter " + variable.getVariableName();
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.methodDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        String importName = PathVariable.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), importName)) {
            ImportRewrite importRewrite = this.createImportRewrite(astRoot);
            importRewrite.addImport(importName);
        }
        this.addLinkedPosition(new ITrackedNodePosition(){

            public int getStartPosition() {
                return AddPathVariableParameterCompletionProposal.this.variable.getOffset();
            }

            public int getLength() {
                return AddPathVariableParameterCompletionProposal.this.variable.getVariableName().length();
            }
        }, true, "variableName");
        SingleVariableDeclaration paramDecl = ast.newSingleVariableDeclaration();
        SimpleType variableType = ast.newSimpleType((Name)ast.newSimpleName("String"));
        paramDecl.setType((Type)variableType);
        this.addLinkedPosition(astRewrite.track((ASTNode)variableType), false, "variableType");
        SimpleName variableName = ast.newSimpleName(this.variable.getVariableName());
        paramDecl.setName(variableName);
        this.addLinkedPosition(astRewrite.track((ASTNode)variableName), false, "variableName");
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName("PathVariable"));
        StringLiteral pathVariableName = ast.newStringLiteral();
        pathVariableName.setLiteralValue(this.variable.getVariableName());
        annotation.setValue((Expression)pathVariableName);
        this.addLinkedPosition(new StringLiteralTrackedPosition(astRewrite.track((ASTNode)pathVariableName)), false, "variableName");
        ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)paramDecl, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertFirst((ASTNode)annotation, null);
        listRewrite = astRewrite.getListRewrite((ASTNode)this.methodDecl, MethodDeclaration.PARAMETERS_PROPERTY);
        listRewrite.insertLast((ASTNode)paramDecl, null);
        return astRewrite;
    }
}

