/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.stereotype.Controller;

public class AddControllerCompletionProposal
extends AnnotationCompletionProposal {
    private final TypeDeclaration typeDecl;

    public AddControllerCompletionProposal(TypeDeclaration typeDecl, ICompilationUnit cu, boolean atTypeDecl) {
        super(AddControllerCompletionProposal.getDisplayName(typeDecl, atTypeDecl), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.typeDecl = typeDecl;
    }

    private static String getDisplayName(TypeDeclaration typeDecl, boolean atTypeDecl) {
        StringBuilder result = new StringBuilder();
        result.append("Add @Controller");
        if (!atTypeDecl) {
            result.append(" to type ");
            result.append(typeDecl.getName().getFullyQualifiedName());
        }
        return result.toString();
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.typeDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        String importName = Controller.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), importName)) {
            ImportRewrite importRewrite = this.createImportRewrite(astRoot);
            importRewrite.addImport(importName);
        }
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName("Controller"));
        astRewrite.getListRewrite((ASTNode)this.typeDecl, TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
        return astRewrite;
    }
}

