/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddInitBinderCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.web.bind.WebDataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitBinderAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    @Override
    public String getAnnotationName() {
        return "InitBinder";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        Type returnType;
        TypeDeclaration typeDecl = this.getSurroundingTypeDecl((ASTNode)methodDecl);
        if (typeDecl != null && ProposalCalculatorUtil.hasAnnotation("Controller", (ASTNode)typeDecl) && !ProposalCalculatorUtil.hasAnnotation("InitBinder", (ASTNode)methodDecl) && (returnType = methodDecl.getReturnType2()).isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
            Class<?> binderClass;
            ClassLoader classLoader = JdtUtils.getProjectClassLoaderSupport((IProject)context.getCompilationUnit().getJavaProject().getProject(), (ClassLoader)BeansCorePlugin.getClassLoader()).getProjectClassLoader();
            try {
                binderClass = classLoader.loadClass(WebDataBinder.class.getCanonicalName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            List params = methodDecl.parameters();
            for (SingleVariableDeclaration param : params) {
                Class<?> paramClass;
                ITypeBinding paramTypeBinding = param.getType().resolveBinding();
                try {
                    paramClass = classLoader.loadClass(paramTypeBinding.getQualifiedName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                if (!binderClass.isAssignableFrom(paramClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddInitBinderCompletionProposal(methodDecl, cu));
        return proposals;
    }
}

