/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddControllerCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    @Override
    public String getAnnotationName() {
        return "Controller";
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddControllerCompletionProposal(this.getTypeDeclaration((ASTNode)methodDecl), cu, false));
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForType(TypeDeclaration typeDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddControllerCompletionProposal(typeDecl, cu, true));
        return proposals;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        TypeDeclaration typeDecl;
        if (this.isControllerNeeded(methodDecl) && (typeDecl = this.getTypeDeclaration((ASTNode)methodDecl)) != null) {
            return !ProposalCalculatorUtil.hasAnnotation("Controller", (ASTNode)typeDecl);
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        MethodDeclaration[] methodDecls;
        if (ProposalCalculatorUtil.hasAnnotation("Controller", (ASTNode)typeDecl)) {
            return false;
        }
        if (ProposalCalculatorUtil.hasAnnotation("RequestMapping", (ASTNode)typeDecl)) {
            return true;
        }
        MethodDeclaration[] methodDeclarationArray = methodDecls = typeDecl.getMethods();
        int n = methodDecls.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDecl = methodDeclarationArray[n2];
            if (this.isControllerNeeded(methodDecl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private TypeDeclaration getTypeDeclaration(ASTNode node) {
        if (node == null || node instanceof TypeDeclaration) {
            return (TypeDeclaration)node;
        }
        return this.getTypeDeclaration(node.getParent());
    }

    private boolean isControllerNeeded(MethodDeclaration methodDecl) {
        return ProposalCalculatorUtil.hasAnnotation("RequestMapping", (ASTNode)methodDecl) || ProposalCalculatorUtil.hasAnnotation("InitBinder", (ASTNode)methodDecl) || ProposalCalculatorUtil.hasAnnotation("ExceptionHandler", (ASTNode)methodDecl);
    }
}

