/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ModifierChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.quickfix.AttributeQuickfixSupport;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.QuickfixSupport;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewMethodQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickfixUtils {
    private static QuickfixSupport attributeQuickfixSupport;

    private static ASTParser createASTParser(IJavaProject javaProject, ICompilationUnit cu, int kind) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(kind);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        return parser;
    }

    public static void createConstructor(IDocument document, IType targetType, List<String> constructorArgClassNames, IJavaProject javaProject) {
        ICompilationUnit cu = targetType.getCompilationUnit();
        if (cu == null) {
            return;
        }
        ITypeBinding typeBinding = QuickfixUtils.getTargetTypeBinding(javaProject, targetType);
        String className = targetType.getFullyQualifiedName();
        ClassInstanceCreation invocationNode = QuickfixUtils.getMockConstructorInvocation(className, constructorArgClassNames.toArray(new String[constructorArgClassNames.size()]));
        List<Expression> arguments = QuickfixUtils.getArguments(invocationNode);
        Object constructorProposal = QuickfixReflectionUtils.createNewMethodProposal(targetType.getElementName(), cu, (ASTNode)invocationNode, arguments, typeBinding, 0, null);
        QuickfixReflectionUtils.applyProposal(constructorProposal, document);
    }

    public static ModifierChangeCorrectionProposal createModifierChangeCorrectionProposal(String className, String fieldName, IJavaProject javaProject, String displayString, boolean isStatic) {
        IType type = JdtUtils.getJavaType((IProject)javaProject.getProject(), (String)className);
        IField field = type.getField(fieldName);
        IBinding binding = QuickfixUtils.getBinding(javaProject, (IJavaElement)field, type.getCompilationUnit(), 8);
        SimpleName fieldNameNode = QuickfixUtils.getMockFieldAccess(className, fieldName, isStatic);
        return new ModifierChangeCorrectionProposal(fieldName, type.getCompilationUnit(), binding, (ASTNode)fieldNameNode, 8, 0, 5, null);
    }

    public static NewVariableCorrectionProposal createNewVariableCorrectionProposal(String className, String fieldName, IJavaProject javaProject, String displayString, boolean isStatic) {
        IType type = JdtUtils.getJavaType((IProject)javaProject.getProject(), (String)className);
        ITypeBinding typeBinding = QuickfixUtils.getTargetTypeBinding(javaProject, type);
        SimpleName fieldNameNode = QuickfixUtils.getMockFieldAccess(className, fieldName, isStatic);
        return new NewVariableCorrectionProposal(displayString, type.getCompilationUnit(), 2, fieldNameNode, typeBinding, 100, JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif"));
    }

    public static List<Expression> getArguments(ClassInstanceCreation constructorInvocation) {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argumentExpression : constructorInvocation.arguments()) {
            arguments.add(argumentExpression);
        }
        return arguments;
    }

    public static List<Expression> getArguments(MethodInvocation methodInvocation) {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argumentExpression : methodInvocation.arguments()) {
            arguments.add(argumentExpression);
        }
        return arguments;
    }

    private static synchronized QuickfixSupport getAttributeQuickfixSupport() {
        if (attributeQuickfixSupport == null) {
            attributeQuickfixSupport = new AttributeQuickfixSupport();
        }
        return attributeQuickfixSupport;
    }

    private static IBinding getBinding(IJavaProject javaProject, IJavaElement javaElement, ICompilationUnit cu, int kind) {
        ASTParser bindingParser = QuickfixUtils.createASTParser(javaProject, cu, kind);
        IBinding[] bindings = bindingParser.createBindings(new IJavaElement[]{javaElement}, (IProgressMonitor)new NullProgressMonitor());
        if (bindings != null && bindings.length > 0) {
            return bindings[0];
        }
        return null;
    }

    public static CompilationUnit getCompilationUnitAST(IJavaProject javaProject, ICompilationUnit cu) {
        ASTParser parser = QuickfixUtils.createASTParser(javaProject, cu, 8);
        ASTNode ast = parser.createAST(null);
        if (ast instanceof CompilationUnit) {
            return (CompilationUnit)ast;
        }
        return null;
    }

    public static String getConfigName(IResource resource) {
        return resource.getProjectRelativePath().toString();
    }

    public static IDocument getDocument(IMarker marker) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = null;
        if (marker.getResource() instanceof IFile) {
            FileEditorInput fileInput = new FileEditorInput((IFile)marker.getResource());
            editor = page.findEditor((IEditorInput)fileInput);
            if (editor == null) {
                try {
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)marker.getResource()));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            if (editor instanceof IConfigEditor) {
                IConfigEditor configEditor = (IConfigEditor)editor;
                return configEditor.getTextViewer().getDocument();
            }
            if (editor instanceof MultiPageEditorPart) {
                IEditorPart[] editors;
                MultiPageEditorPart multiEditor = (MultiPageEditorPart)editor;
                IEditorPart[] iEditorPartArray = editors = multiEditor.findEditors((IEditorInput)fileInput);
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart e = iEditorPartArray[n2];
                    if (e instanceof StructuredTextEditor) {
                        return ((StructuredTextEditor)e).getDocumentProvider().getDocument((Object)fileInput);
                    }
                    ++n2;
                }
            } else if (editor instanceof AbstractDecoratedTextEditor) {
                return ((AbstractDecoratedTextEditor)editor).getDocumentProvider().getDocument((Object)fileInput);
            }
        }
        return null;
    }

    public static IDOMNode getEnclosingBeanNode(IDOMNode node) {
        if (node == null) {
            return null;
        }
        String localName = node.getLocalName();
        if (localName != null && localName.equals(BeansSchemaConstants.ELEM_BEAN)) {
            return node;
        }
        Node parentNode = node.getParentNode();
        if (parentNode instanceof IDOMNode) {
            return QuickfixUtils.getEnclosingBeanNode((IDOMNode)parentNode);
        }
        return null;
    }

    public static IMethodBinding getMethodBinding(IJavaProject javaProject, IMethod method) {
        IBinding binding = QuickfixUtils.getBinding(javaProject, (IJavaElement)method, method.getCompilationUnit(), 4);
        if (binding != null && binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    public static MethodDeclaration getMethodDecl(IMethod method) {
        ASTParser parser = QuickfixUtils.createASTParser(method.getJavaProject(), method.getCompilationUnit(), 8);
        ASTNode ast = parser.createAST(null);
        if (ast instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)ast;
            ASTFinder visitor = new ASTFinder(method);
            cu.accept((ASTVisitor)visitor);
            return visitor.getMethodDeclaration();
        }
        return null;
    }

    public static ClassInstanceCreation getMockConstructorInvocation(String className, String[] argTypes) {
        String varSetup = "";
        String methodArgs = "";
        int i = 0;
        while (i < argTypes.length) {
            String argType = argTypes[i];
            varSetup = String.valueOf(varSetup) + argType + " arg" + i + ";";
            if (i > 0) {
                methodArgs = String.valueOf(methodArgs) + ",";
            }
            methodArgs = String.valueOf(methodArgs) + "arg" + i;
            ++i;
        }
        String mockConstructorCode = String.valueOf(varSetup) + "new " + className + "(" + methodArgs + ");";
        return QuickfixUtils.getParsedExpressionFinder(mockConstructorCode, false).getConstructorInvocation();
    }

    public static SimpleName getMockFieldAccess(String className, String fieldName, boolean isStatic) {
        String code = String.valueOf(fieldName) + "=null;";
        if (isStatic) {
            code = "public static void stub() {" + code + "}";
        }
        return QuickfixUtils.getParsedExpressionFinder(code, isStatic).getFieldAccess();
    }

    public static MethodInvocation getMockMethodInvocation(String methodName, String[] argTypes, String returnType, boolean isStatic) {
        String varSetup = "";
        String methodArgs = "";
        int i = 0;
        while (i < argTypes.length) {
            String argType = argTypes[i];
            varSetup = String.valueOf(varSetup) + argType + " arg" + i + ";";
            if (i > 0) {
                methodArgs = String.valueOf(methodArgs) + ",";
            }
            methodArgs = String.valueOf(methodArgs) + "arg" + i;
            ++i;
        }
        String mockMethodInvocationCode = String.valueOf(methodName) + "(" + methodArgs + ");";
        if (returnType != null) {
            mockMethodInvocationCode = String.valueOf(varSetup) + returnType + " xxx = " + mockMethodInvocationCode;
        }
        if (isStatic) {
            mockMethodInvocationCode = "static {" + mockMethodInvocationCode + "}";
        }
        return QuickfixUtils.getParsedExpressionFinder(mockMethodInvocationCode, isStatic).getMethodInvocation();
    }

    public static CreateNewMethodQuickFixProposal getNewMethodQuickFixProposal(String methodName, String returnType, String[] methodParamTypes, IJavaProject javaProject, String className, int offset, int length, String text, boolean missingEndQuote, boolean isStatic, String elementType) {
        IType targetType = null;
        try {
            targetType = javaProject.findType(className);
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Asssit Error", (String)("Could not find class '" + className + "'"));
            return null;
        }
        if (targetType == null) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Could not find class '" + className + "'"));
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Quick Fix Error", (String)("Could not find class '" + className + "'"));
            return null;
        }
        MethodInvocation mockMethodInvocation = QuickfixUtils.getMockMethodInvocation(methodName, methodParamTypes, returnType, isStatic);
        if (mockMethodInvocation == null) {
            return null;
        }
        ITypeBinding typeBinding = QuickfixUtils.getTargetTypeBinding(javaProject, targetType);
        List<Expression> arguments = QuickfixUtils.getArguments(mockMethodInvocation);
        ICompilationUnit cu = targetType.getCompilationUnit();
        if (cu == null || typeBinding == null || arguments == null) {
            return null;
        }
        return new CreateNewMethodQuickFixProposal(offset, length, "Add missing " + elementType + " '" + text + "' in class '" + className + "'", cu, (ASTNode)mockMethodInvocation, arguments, typeBinding, 0, missingEndQuote);
    }

    private static ASTFinder getParsedExpressionFinder(String toBeParsed, boolean isStatic) {
        ASTParser fooParser = ASTParser.newParser((int)4);
        if (isStatic) {
            fooParser.setKind(4);
        } else {
            fooParser.setKind(2);
        }
        fooParser.setSource(toBeParsed.toCharArray());
        fooParser.setResolveBindings(true);
        ASTNode parsedAstNode = fooParser.createAST(null);
        ASTFinder visitor = new ASTFinder();
        parsedAstNode.accept((ASTVisitor)visitor);
        return visitor;
    }

    public static ITypeBinding getTargetTypeBinding(IJavaProject javaProject, IType targetType) {
        IBinding binding = QuickfixUtils.getBinding(javaProject, (IJavaElement)targetType, targetType.getCompilationUnit(), 8);
        if (binding != null && binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static BodyDeclaration getTypeDecl(String className, ICompilationUnit compUnit) {
        ASTParser parser = QuickfixUtils.createASTParser(compUnit.getJavaProject(), compUnit, 8);
        ASTNode ast = parser.createAST(null);
        if (ast instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)ast;
            ASTFinder visitor = new ASTFinder(className);
            cu.accept((ASTVisitor)visitor);
            return visitor.getTypeDeclaration();
        }
        return null;
    }

    private static Set<BeanValidator> getValidators(Node node, Attr attr) {
        return QuickfixUtils.getAttributeQuickfixSupport().getQuickfixValidators(node, attr);
    }

    public static boolean validateAttribute(IBeansConfig config, IResourceModelElement contextElement, AttrImpl attrImpl, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator editorValidator) {
        Set<BeanValidator> beanValidators = QuickfixUtils.getValidators((Node)parent, (Attr)attrImpl);
        boolean errorFound = false;
        for (BeanValidator beanValidator : beanValidators) {
            errorFound |= beanValidator.validateAttributeWithConfig(config, contextElement, attrImpl, parent, reporter, reportError, editorValidator);
        }
        return errorFound;
    }

    private static class ASTFinder
    extends ASTVisitor {
        private MethodInvocation methodInvo;
        private ClassInstanceCreation constInvo;
        private Assignment assignment;
        private MethodDeclaration methodDecl;
        private IMethod methodToMatch;
        private String classNameToMatch;
        private TypeDeclaration typeDecl;

        private ASTFinder() {
        }

        private ASTFinder(IMethod methodToMatch) {
            this.methodToMatch = methodToMatch;
        }

        private ASTFinder(String classNameToMatch) {
            int pos = classNameToMatch.lastIndexOf(".");
            this.classNameToMatch = pos > 0 ? classNameToMatch.substring(pos + 1) : classNameToMatch;
        }

        private ClassInstanceCreation getConstructorInvocation() {
            return this.constInvo;
        }

        private SimpleName getFieldAccess() {
            if (this.assignment == null) {
                return null;
            }
            Expression lhs = this.assignment.getLeftHandSide();
            if (lhs instanceof SimpleName) {
                return (SimpleName)lhs;
            }
            if (lhs instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)lhs;
                return qn.getName();
            }
            return null;
        }

        private MethodDeclaration getMethodDeclaration() {
            return this.methodDecl;
        }

        private MethodInvocation getMethodInvocation() {
            return this.methodInvo;
        }

        private TypeDeclaration getTypeDeclaration() {
            return this.typeDecl;
        }

        public boolean visit(Assignment node) {
            this.assignment = node;
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.constInvo = node;
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.methodToMatch != null && node.getName().getFullyQualifiedName().equals(this.methodToMatch.getElementName()) && node.parameters().size() == this.methodToMatch.getNumberOfParameters()) {
                this.methodDecl = node;
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(MethodInvocation node) {
            this.methodInvo = node;
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            if (node.getName().getFullyQualifiedName().equals(this.classNameToMatch)) {
                this.typeDecl = node;
                return false;
            }
            return true;
        }
    }
}

