/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.branding.ui.preferences;

import com.atlassian.connector.eclipse.internal.branding.ui.AtlassianBrandingPlugin;
import com.atlassian.connector.eclipse.internal.ui.AtlassianBundlesInfo;
import com.atlassian.connector.eclipse.internal.ui.AtlassianLogo;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AtlassianPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TEXT_MAIN = "The Atlassian Eclipse Connector is an Eclipse plugin that lets you work with the Atlassian products within your IDE. Now you don't have to switch between websites, email messages and news feeds to see what's happening to your project and your code. Instead, you can see the relevant <a href=\"http://www.atlassian.com/software/jira\">JIRA</a> issues and <a href=\"http://www.atlassian.com/software/bamboo\">Bamboo</a> build information right there in your development environment.";

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(composite);
        Composite white = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)white);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(white);
        white.setBackground(Display.getDefault().getSystemColor(1));
        Composite center = new Composite(white, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)center);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 0).spacing(0, 0).applyTo(center);
        Label label = new Label(center, 0x1000000);
        Image image = AtlassianLogo.getImage(AtlassianLogo.ATLASSIAN_LOGO);
        label.setImage(image);
        int logoWidth = image.getBounds().width + 100;
        GridDataFactory.fillDefaults().align(0x1000000, 4).hint(logoWidth, image.getBounds().height).applyTo((Control)label);
        label.setBackground(Display.getDefault().getSystemColor(1));
        center.setBackground(Display.getDefault().getSystemColor(1));
        Composite nestedComposite = new Composite(center, 0);
        nestedComposite.setBackground(Display.getDefault().getSystemColor(1));
        GridLayoutFactory.fillDefaults().numColumns(1).margins(4, 0).applyTo(nestedComposite);
        GridDataFactory.fillDefaults().align(0x1000000, 4).hint(logoWidth, -1).applyTo((Control)nestedComposite);
        Link link = new Link(nestedComposite, 0);
        link.setText(TEXT_MAIN);
        link.setBackground(Display.getDefault().getSystemColor(1));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openUrl((String)e.text);
            }
        });
        GridDataFactory.fillDefaults().align(0x1000000, 128).hint(logoWidth, -1).applyTo((Control)link);
        FontRegistry fontRegistry = new FontRegistry();
        fontRegistry.put("big", new FontData[]{new FontData("Arial", 18, 1)});
        Font bigFont = fontRegistry.get("big");
        new Label(nestedComposite, 0).setVisible(false);
        Link link2 = this.createLink(nestedComposite, "Developed by Atlassian for you to lust after", -1);
        link2.setFont(bigFont);
        link2.setText("Developed by Atlassian for you to lust after");
        Link link3 = this.createLink(nestedComposite, "<a href=\"http://www.atlassian.com/\">http://www.atlassian.com/</a>", -1);
        link3.setFont(bigFont);
        new Label(nestedComposite, 0).setVisible(false);
        this.createLink(nestedComposite, "Licensed under the Eclipse Public License Version 1.0 (\"EPL\").", -1);
        this.createLink(nestedComposite, "Copyright (c) Atlassian 2009", -1);
        new Label(nestedComposite, 0).setVisible(false);
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayout((Layout)new RowLayout());
        this.createButton(buttonBar, "On-line Help", "http://confluence.atlassian.com/display/IDEPLUGIN/Atlassian+Connector+for+Eclipse");
        this.createButton(buttonBar, "Visit Forum", "http://forums.atlassian.com/forum.jspa?forumID=124&start=0");
        this.createButton(buttonBar, "Request Support", "https://support.atlassian.com/browse/ECSP");
        this.createButton(buttonBar, "Report Bug", "https://studio.atlassian.com/browse/PLE");
        if (AtlassianBundlesInfo.isOnlyJiraInstalled()) {
            this.createButton(buttonBar, "Install Bamboo, Crucible && FishEye Integration", "http://www.atlassian.com/software/ideconnector/eclipse.jsp?src=jiraconnector");
        }
        return composite;
    }

    private Link createLink(Composite parent, String text, int width) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.setBackground(Display.getDefault().getSystemColor(1));
        GridDataFactory.fillDefaults().align(0x1000000, 128).hint(width, -1).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openUrl((String)e.text);
            }
        });
        return link;
    }

    private void createButton(Composite parent, String text, final String url) {
        Button helpButton = new Button(parent, 8);
        helpButton.setText(text);
        helpButton.setToolTipText("Open " + url);
        helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openUrl((String)url);
            }
        });
    }

    public AtlassianPreferencePage() {
        this.noDefaultAndApplyButton();
        this.setPreferenceStore(AtlassianBrandingPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }
}

