/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.wizards;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.ui.properties.BeansConfigContentProvider;
import org.springframework.ide.eclipse.webflow.ui.properties.BeansConfigLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkToBeansConfigWizardPage
extends WizardPage {
    private static final int BEANS_CONFIG_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private CheckboxTableViewer beansConfigSetViewer;
    private Text nameText;
    private List<String> config;

    protected LinkToBeansConfigWizardPage(String pageName) {
        super(pageName);
        this.setTitle("New Web Flow Definition file");
        this.setDescription("Define details for the Spring Web Flow Definition file");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Specify a flow id");
        this.nameText = new Text(composite, 2052);
        if (this.config != null && this.config.size() > 0 && this.config.get(0) != null) {
            this.nameText.setText(this.config.get(0));
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        Label beansLabel = new Label(composite, 0);
        beansLabel.setText("Link Spring Beans configs to Web Flow flow");
        this.beansConfigSetViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.beansConfigSetViewer.getTable().setLayoutData((Object)gd);
        this.beansConfigSetViewer.setContentProvider((IContentProvider)new BeansConfigContentProvider(this.createBeansConfigList()));
        this.beansConfigSetViewer.setLabelProvider((IBaseLabelProvider)new BeansConfigLabelProvider());
        this.beansConfigSetViewer.setInput((Object)this);
    }

    private Set<IModelElement> createBeansConfigList() {
        HashSet<IModelElement> configs = new HashSet<IModelElement>();
        Set beansProjects = BeansCorePlugin.getModel().getProjects();
        for (IBeansProject project : beansProjects) {
            configs.addAll(project.getConfigs());
            configs.addAll(project.getConfigSets());
        }
        return configs;
    }

    public Set<IModelElement> getBeansConfigs() {
        HashSet<IModelElement> configs = new HashSet<IModelElement>();
        Object[] checkedElements = this.beansConfigSetViewer.getCheckedElements();
        if (checkedElements != null) {
            int i = 0;
            while (i < checkedElements.length) {
                configs.add((IModelElement)((IBeansConfig)checkedElements[i]));
                ++i;
            }
        }
        return configs;
    }

    public String getName() {
        return this.nameText.getText();
    }
}

