/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelListener;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowNavigatorContentProvider
implements ICommonContentProvider,
IWebflowModelListener {
    private String providerID;
    private StructuredViewer viewer;

    public void init(ICommonContentExtensionSite config) {
        this.providerID = config.getExtension().getId();
        Activator.getModel().registerModelChangeListener((IWebflowModelListener)this);
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISpringProject) {
            if (this.hasChildren(parentElement)) {
                return new Object[]{Activator.getModel().getProject(((ISpringProject)parentElement).getProject())};
            }
        } else {
            if (parentElement instanceof IWebflowProject) {
                return WebflowModelUtils.getFiles((IProject)((IWebflowProject)parentElement).getProject()).toArray();
            }
            if (parentElement instanceof IFile) {
                IFile file = (IFile)parentElement;
                if (WebflowModelUtils.isWebflowConfig((IResource)file)) {
                    return new Object[]{WebflowModelUtils.getWebflowConfig((IFile)file)};
                }
            } else if (parentElement instanceof IWebflowConfig) {
                ArrayList<Object> children = new ArrayList<Object>();
                for (IModelElement config : ((IWebflowConfig)parentElement).getBeansConfigs()) {
                    if (config instanceof IBeansConfig) {
                        children.add(((IBeansConfig)config).getElementResource());
                        continue;
                    }
                    children.add(config);
                }
                return children.toArray();
            }
        }
        return IModelElement.NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof IWebflowModelElement) {
            return ((IWebflowModelElement)element).getElementParent();
        }
        if (element instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IFile)element))) {
            return WebflowModelUtils.getWebflowConfig((IFile)((IFile)element)).getProject();
        }
        if (element instanceof IWebflowProject) {
            return SpringCore.getModel().getProject(((IWebflowProject)element).getProject());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        IWebflowConfig config;
        if (element instanceof ISpringProject) {
            return Activator.getModel().getProject(((ISpringProject)element).getProject()).getConfigs().size() > 0;
        }
        if (element instanceof IWebflowProject) {
            return ((IWebflowProject)element).getConfigs().size() > 0;
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return WebflowModelUtils.isWebflowConfig((IResource)file);
        }
        return element instanceof IWebflowConfig && (config = (IWebflowConfig)element).getBeansConfigs() != null && config.getBeansConfigs().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        return IModelElement.NO_CHILDREN;
    }

    public void dispose() {
        Activator.getModel().removeModelChangeListener((IWebflowModelListener)this);
    }

    public void modelChanged(IWebflowProject project) {
        if (project != null) {
            IProject p = project.getProject();
            if ("org.springframework.ide.eclipse.webflow.ui.navigator.projectExplorerContent".equals(this.providerID)) {
                this.refreshViewerForElement(p);
                this.refreshViewerForElement(JdtUtils.getJavaProject((IProject)p));
            } else if ("org.springframework.ide.eclipse.webflow.ui.navigator.springExplorerContent".equals(this.providerID)) {
                this.refreshViewerForElement(SpringCore.getModel().getProject(p));
            }
        }
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            if (oldInput == null && newInput != null) {
                Activator.getModel().registerModelChangeListener((IWebflowModelListener)this);
            } else if (oldInput != null && newInput == null) {
                Activator.getModel().removeModelChangeListener((IWebflowModelListener)this);
            }
        } else {
            this.viewer = null;
        }
    }

    protected final void refreshViewerForElement(final Object element) {
        if (this.viewer instanceof StructuredViewer && element != null) {
            Control ctrl = this.viewer.getControl();
            if (ctrl == null || ctrl.isDisposed()) {
                return;
            }
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                this.viewer.refresh(element);
            } else {
                ctrl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Control ctrl = WebflowNavigatorContentProvider.this.viewer.getControl();
                        if (ctrl == null || ctrl.isDisposed()) {
                            return;
                        }
                        if (element instanceof IWebflowModel) {
                            WebflowNavigatorContentProvider.this.viewer.refresh();
                        } else {
                            WebflowNavigatorContentProvider.this.viewer.refresh(element);
                        }
                    }
                });
            }
        }
    }

    public String toString() {
        return String.valueOf(this.providerID);
    }
}

