/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetValidationRule
implements IValidationRule<Set, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof Set && context instanceof WebflowValidationContext;
    }

    public void validate(Set set, WebflowValidationContext context, IProgressMonitor monitor) {
        if (context.isVersion1()) {
            if (!StringUtils.hasText((String)set.getAttribute())) {
                context.error(set, "NO_ATTRIBUTE_ATTRIBUTE", "Element 'set' requires 'attribute' attribute", new ValidationProblemAttribute[0]);
            }
            if (!StringUtils.hasText((String)set.getValue())) {
                context.error(set, "NO_VALUE_ATTRIBUTE", "Element 'set' requires 'value' attribute", new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)set.getScope()) && !WebflowValidationRuleUtils.SCOPE_TYPES.contains(set.getScope())) {
                context.error(set, "NO_ATTRIBUTE_ATTRIBUTE", "Element 'set' requires 'attribute' attribute", new ValidationProblemAttribute[0]);
                context.error(set, "NO_VALUE_ATTRIBUTE", MessageUtils.format((String)"Element 'set' requires 'value' attribute", (Object)set.getScope()), new ValidationProblemAttribute[0]);
            }
        } else {
            if (!StringUtils.hasText((String)set.getName())) {
                context.error(set, "NO_NAME_ATTRIBUTE", "Element 'set' requires 'name' attribute", new ValidationProblemAttribute[0]);
            }
            if (!StringUtils.hasText((String)set.getValue())) {
                context.error(set, "NO_VALUE_ATTRIBUTE", "Element 'set' requires 'value' attribute", new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)set.getSetType())) {
                IType type = WebflowValidationRuleUtils.getJavaType(set.getSetType(), context);
                if (type == null) {
                    context.error(set, "INVALID_TYPE", MessageUtils.format((String)"Set 'type' \"{0}\" cannot be resolved", (Object)set.getSetType()), new ValidationProblemAttribute[0]);
                } else {
                    try {
                        if (type.isInterface() || Flags.isAbstract((int)type.getFlags())) {
                            context.error(set, "INVALID_TYPE", MessageUtils.format((String)"Set 'type' \"{0}\" is either an Interface or abstract", (Object)set.getSetType()), new ValidationProblemAttribute[0]);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
    }
}

