/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionValidationRule
implements IValidationRule<Action, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof Action && context instanceof WebflowValidationContext;
    }

    public void validate(Action action, WebflowValidationContext context, IProgressMonitor monitor) {
        if (context.isVersion1()) {
            if (!StringUtils.hasText((String)action.getBean())) {
                context.error(action, "NO_BEAN_ATTRIBUTE", "Element 'action' requires 'bean' attribute", new ValidationProblemAttribute[0]);
            } else if (!WebflowModelUtils.isReferencedBeanFound(context.getWebflowConfig(), action.getBean())) {
                context.error(action, "INVALID_BEAN", MessageUtils.format((String)"Referenced bean \"{0}\" cannot be found", (Object)action.getBean()), new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)action.getMethod()) && !JdtUtils.doesImplement((IResource)context.getWebflowConfig().getElementResource(), (IType)WebflowModelUtils.getActionType(context.getWebflowConfig(), action.getNode()), (String)FactoryBean.class.getName())) {
                Set<IMethod> methods = WebflowModelUtils.getActionMethods(context.getWebflowConfig(), action.getNode());
                boolean found = false;
                for (IMethod method : methods) {
                    if (!method.getElementName().equals(action.getMethod())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    context.error(action, "INVALID_ACTION_METHOD", MessageUtils.format((String)"Referenced action method \"{0}\" cannot be found or is not a valid action method", (Object)action.getMethod()), new ValidationProblemAttribute[0]);
                }
            }
        } else if (!StringUtils.hasText((String)action.getAttribute(action.getNode(), "fragments"))) {
            context.error(action, "NO_FRAGMENTS", "Element 'render' requires 'fragments' attribute", new ValidationProblemAttribute[0]);
        }
    }
}

