/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.FlagsMethodFilter;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.InlineFlowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowModelUtils {
    private static final Set<IMethod> NO_METHOD_MATCHES = new HashSet<IMethod>();
    private static final String EVENT_CLASS = "org.springframework.webflow.execution.Event";
    private static final String REQUEST_CONTEXT_CLASS = "org.springframework.webflow.execution.RequestContext";

    public static IMethodFilter getBeanMethodFilter() {
        return new FlagsMethodFilter(20484, EVENT_CLASS, new String[]{REQUEST_CONTEXT_CLASS});
    }

    public static IMethodFilter getBeanActionMethodFilter() {
        return new FlagsMethodFilter(20484);
    }

    public static IType getActionType(IWebflowConfig config, IDOMNode node) {
        Set<IBean> beans = WebflowModelUtils.getBeans(config);
        String className = null;
        for (IBean bean : beans) {
            if (!bean.getElementName().equals(BeansEditorUtils.getAttribute((Node)node, (String)"bean"))) continue;
            className = BeansModelUtils.getBeanClass((IBean)bean, null);
            break;
        }
        return JdtUtils.getJavaType((IProject)config.getProject().getProject(), className);
    }

    public static Set<IMethod> getActionMethods(IWebflowConfig config, IDOMNode node) {
        IType type = WebflowModelUtils.getActionType(config, node);
        if (type != null) {
            if ("bean-action".equals(node.getLocalName())) {
                return Introspector.findAllMethods((IType)type, (IMethodFilter)WebflowModelUtils.getBeanActionMethodFilter());
            }
            return Introspector.findAllMethods((IType)type, (IMethodFilter)WebflowModelUtils.getBeanMethodFilter());
        }
        return NO_METHOD_MATCHES;
    }

    public static Set<IBean> getBeans(IWebflowConfig config) {
        Set<IModelElement> beansConfigs = config.getBeansConfigs();
        HashSet<IBean> beans = new HashSet<IBean>();
        if (beansConfigs != null) {
            for (IModelElement bc : beansConfigs) {
                beans.addAll(BeansModelUtils.getBeans((IModelElement)bc, null));
            }
        }
        return beans;
    }

    public static List<IFile> getFiles(IProject project) {
        IWebflowProject webflowProject = Activator.getModel().getProject(project);
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (webflowProject != null) {
            for (IWebflowConfig config : webflowProject.getConfigs()) {
                files.add(config.getResource());
            }
        }
        return files;
    }

    public static IWebflowConfig getWebflowConfig(IFile file) {
        IWebflowModel model = Activator.getModel();
        return file != null && file.getProject() != null && model.getProject(file.getProject()) != null && model.getProject(file.getProject()).getConfig(file) != null ? model.getProject(file.getProject()).getConfig(file) : null;
    }

    public static IWebflowState getWebflowState(IFile file) {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            if (model == null) {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
            }
            if (model != null) {
                IDOMDocument document = ((DOMModelImpl)model).getDocument();
                WebflowState webflowState = new WebflowState(WebflowModelUtils.getWebflowConfig(file));
                webflowState.init((IDOMNode)document.getDocumentElement(), null);
                WebflowState webflowState2 = webflowState;
                return webflowState2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public static boolean isReferencedBeanFound(IWebflowConfig config, String beanName) {
        Set<IModelElement> beansConfigs = config.getBeansConfigs();
        for (IModelElement beansConfig : beansConfigs) {
            if (BeansModelUtils.getBean((String)beanName, (IModelElement)beansConfig) == null) continue;
            return true;
        }
        return false;
    }

    public static IWebflowState getWebflowState(IWebflowModelElement element, boolean resolveToRoot) {
        if (element != null) {
            if (element instanceof IWebflowState) {
                if (resolveToRoot && element.getElementParent() instanceof InlineFlowState) {
                    return WebflowModelUtils.getWebflowState((IWebflowModelElement)element.getElementParent(), resolveToRoot);
                }
                return (IWebflowState)element;
            }
            return WebflowModelUtils.getWebflowState((IWebflowModelElement)element.getElementParent(), resolveToRoot);
        }
        return null;
    }

    public static IState getState(IWebflowModelElement element) {
        if (element != null) {
            if (element instanceof IState) {
                return (IState)element;
            }
            return WebflowModelUtils.getState((IWebflowModelElement)element.getElementParent());
        }
        return null;
    }

    public static boolean isWebflowConfig(IResource resource) {
        if (resource instanceof IFile && resource.isAccessible()) {
            return WebflowModelUtils.getWebflowConfig((IFile)resource) != null;
        }
        return false;
    }

    public static boolean isStateIdUnique(IState state) {
        IWebflowState webflowState = WebflowModelUtils.getWebflowState(state, false);
        ArrayList<IState> foundStates = new ArrayList<IState>();
        if (webflowState != null) {
            ArrayList<IState> states = new ArrayList<IState>();
            states.addAll(webflowState.getStates());
            states.addAll(webflowState.getInlineFlowStates());
            for (IState s : states) {
                if (!s.getId().equals(state.getId())) continue;
                foundStates.add(s);
            }
        }
        return foundStates.size() == 1;
    }

    public static Set<String> getWebflowConfigNames(IWebflowProject project) {
        HashSet<String> flowNames = new HashSet<String>();
        for (IWebflowConfig config : project.getConfigs()) {
            flowNames.add(config.getName());
        }
        return flowNames;
    }

    public static Set<String> getWebflowConfigNames(IWebflowState state) {
        HashSet<String> flowNames = new HashSet<String>();
        for (IInlineFlowState config : state.getInlineFlowStates()) {
            flowNames.add(config.getId());
        }
        return flowNames;
    }
}

