/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowProject;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowResourceChangeEvents;
import org.springframework.ide.eclipse.webflow.core.internal.model.resources.WebflowResourceChangeListener;
import org.springframework.ide.eclipse.webflow.core.internal.model.update.WebflowModelUpdater;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelListener;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowModel
extends AbstractModelElement
implements IWebflowModel,
IResourceChangeListener {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private List<IWebflowModelListener> listners = new ArrayList<IWebflowModelListener>();
    private Map<IProject, IWebflowProject> projects = new ConcurrentHashMap<IProject, IWebflowProject>();
    private IResourceChangeListener workspaceListener;

    @Override
    public boolean hasProject(IProject project) {
        try {
            this.r.lock();
            if (project != null && project.isAccessible() && this.projects.containsKey(project) && SpringCoreUtils.isSpringProject((IResource)project)) {
                return true;
            }
        }
        finally {
            this.r.unlock();
        }
        return false;
    }

    @Override
    public IWebflowProject getProject(IProject project) {
        try {
            this.r.lock();
            if (this.hasProject(project)) {
                IWebflowProject iWebflowProject = this.projects.get(project);
                return iWebflowProject;
            }
        }
        finally {
            this.r.unlock();
        }
        return new WebflowProject(project, this);
    }

    public IWebflowProject getProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return this.getProject(project);
    }

    public Collection<IWebflowProject> getProjects() {
        try {
            this.r.lock();
            Collection<IWebflowProject> collection = this.projects.values();
            return collection;
        }
        finally {
            this.r.unlock();
        }
    }

    public IWebflowConfig getConfig(IFile configFile) {
        IWebflowProject project;
        if (configFile != null && (project = this.getProject(configFile.getProject())) != null) {
            return project.getConfig(configFile);
        }
        return null;
    }

    public void startup() {
        this.initialize();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        this.workspaceListener = new WebflowResourceChangeListener(new WebflowResourceChangeEvents());
        workspace.addResourceChangeListener(this.workspaceListener, 62);
    }

    public void shutdown() {
        this.initialize();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        workspace.removeResourceChangeListener(this.workspaceListener);
        this.workspaceListener = null;
        this.projects.clear();
    }

    private void initialize() {
        try {
            this.w.lock();
            this.projects.clear();
            List<IProject> projects = WebflowModel.getBeansProjects();
            if (!projects.isEmpty()) {
                for (IProject project : projects) {
                    this.projects.put(project, new WebflowProject(project, this));
                }
            }
            WebflowModelUpdater.updateModel(this.getProjects());
        }
        finally {
            this.w.unlock();
        }
    }

    private static List<IProject> getBeansProjects() {
        ArrayList<IProject> springProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (SpringCoreUtils.isSpringProject((IResource)project)) {
                springProjects.add(project);
            }
            ++i;
        }
        return springProjects;
    }

    @Override
    public void registerModelChangeListener(IWebflowModelListener listener) {
        this.listners.add(listener);
    }

    @Override
    public void removeModelChangeListener(IWebflowModelListener listener) {
        this.listners.remove(listener);
    }

    @Override
    public void fireModelChangedEvent(IWebflowProject project) {
        for (IWebflowModelListener listener : this.listners) {
            listener.modelChanged(project);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (event.getSource() instanceof IWorkspace && (delta = event.getDelta()) != null) {
            try {
                delta.accept((IResourceDeltaVisitor)new WebflowProjectVisitor());
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void removeProject(IProject project) {
        this.initialize();
        this.fireModelChangedEvent(null);
    }

    public IModelElement[] getElementChildren() {
        HashSet<IWebflowProject> children = new HashSet<IWebflowProject>();
        try {
            this.r.lock();
            children.addAll(this.projects.values());
        }
        finally {
            this.r.unlock();
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IWebflowProject project : this.getProjects()) {
                project.accept(visitor, monitor);
            }
        }
    }

    @Override
    public String getElementName() {
        return "WebflowModel";
    }

    @Override
    public IResource getElementResource() {
        return null;
    }

    @Override
    public boolean isElementArchived() {
        return false;
    }

    private class WebflowProjectVisitor
    implements IResourceDeltaVisitor {
        private WebflowProjectVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 2: {
                    if (!(resource instanceof IFile)) break;
                    IFile file = (IFile)resource;
                    IWebflowProject wfProject = WebflowModel.this.getProject(file.getProject());
                    if (wfProject != null && wfProject.getConfig((IFile)resource) != null) {
                        IWebflowConfig config = wfProject.getConfig((IFile)resource);
                        List<IWebflowConfig> configs = wfProject.getConfigs();
                        configs.remove(config);
                        wfProject.setConfigs(configs);
                    }
                    return false;
                }
            }
            return true;
        }
    }
}

