/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.internal.model.If;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionState
extends AbstractTransitionableFrom
implements IDecisionState,
ICloneableModelElement<IDecisionState> {
    private List<IIf> ifs = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        this.init(node, parent, true);
    }

    public void init(IDOMNode node, IWebflowModelElement parent, boolean initIfs) {
        super.init(node, parent);
        if (initIfs) {
            this.ifs = new ArrayList<IIf>();
            this.initIfs(node, parent);
        }
    }

    private void initIfs(IDOMNode node, IWebflowModelElement parent) {
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("if".equals(child.getLocalName())) {
                    If if_ = new If((IWebflowState)parent);
                    if_.init(child, this);
                    this.ifs.add(if_);
                }
                ++i;
            }
        }
    }

    @Override
    public List<IIf> getIfs() {
        return this.ifs;
    }

    @Override
    public void addIf(IIf theIf) {
        if (!this.ifs.contains(theIf)) {
            this.ifs.add(theIf);
            super.firePropertyChange("add_children", new Integer(this.ifs.indexOf(theIf)), theIf);
        }
    }

    @Override
    public void addIf(IIf theIf, int i) {
        if (!this.ifs.contains(theIf)) {
            this.ifs.add(i, theIf);
            super.firePropertyChange("add_children", new Integer(i), theIf);
        }
    }

    @Override
    public void removeIf(IIf theIf) {
        if (this.ifs.contains(theIf)) {
            this.ifs.remove(theIf);
            this.getNode().removeChild((Node)theIf.getNode());
            super.fireStructureChange("remove_children", theIf);
        }
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("decision-state");
        this.init(node, parent);
    }

    @Override
    public IDecisionState cloneModelElement() {
        DecisionState state = new DecisionState();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IDecisionState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setId(element.getId());
            this.init(element.getNode(), this.parent, false);
            if (this.ifs != null && this.ifs.size() > 0) {
                int i = 0;
                while (i < this.ifs.size()) {
                    this.ifs.get(i).setTest(element.getIfs().get(i).getTest());
                    ++i;
                }
            }
            super.fireStructureChange("move_children", new Integer(1));
        }
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            for (IIf iIf : this.getIfs()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iIf.accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getExitActions() != null) {
                this.getExitActions().accept(visitor, monitor);
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
            for (ITransition iTransition : this.getOutputTransitions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iTransition.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEntryActions());
        children.addAll(this.getIfs());
        children.add(this.getExitActions());
        children.addAll(this.getExceptionHandlers());
        children.addAll(this.getOutputTransitions());
        return children.toArray(new IModelElement[children.size()]);
    }
}

