/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    private static final int BUF_SIZE = 0;

    public static void pipe(InputStream data, File target) throws IOException {
        target.getParentFile().mkdirs();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            IOUtil.pipe(data, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void pipe(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int n = input.read(buf);
            while (n >= 0) {
                output.write(buf, 0, n);
                n = input.read(buf);
            }
            output.flush();
        }
        finally {
            input.close();
        }
    }
}

