/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.tips;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.springsource.ide.eclipse.commons.internal.ui.UiPlugin;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.springsource.ide.eclipse.commons.ui.tips.TipInfo;
import org.springsource.ide.eclipse.commons.ui.tips.TipProvider;

public class TipOfTheDayPopup
extends PopupDialog {
    private static final String DIALOG_SETTINGS_SECTION = "TipOfTheDayPopup";
    private static final int POPUP_OFFSET = 20;
    IPreferenceStore prefs;
    Composite dialogArea;
    Link preferenceLink;
    int tipCounter = 0;
    private Button dontRemindButton;
    private Composite tipComposite;
    private final TipProvider provider;

    public TipOfTheDayPopup(Shell parentShell, IPreferenceStore prefs, TipProvider provider) {
        super(parentShell, 16, false, true, true, false, false, "Spring Tool Tips", null);
        this.prefs = prefs;
        this.provider = provider;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = new Composite(parent, 0);
        this.dialogArea.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.dialogArea.setLayout((Layout)layout);
        this.createTip(this.provider.nextTip(), false);
        this.createNextPrevArea(this.dialogArea);
        this.createDontRemindSection(this.dialogArea);
        this.resize();
        return this.dialogArea;
    }

    private void createTip(TipInfo tip, boolean doResize) {
        if (this.tipComposite != null) {
            Control[] children;
            Control[] controlArray = children = this.tipComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
        } else {
            this.tipComposite = new Composite(this.dialogArea, 0);
            this.tipComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.tipComposite.setLayout((Layout)new GridLayout(1, false));
        }
        this.createTipSection(this.tipComposite, tip);
        if (doResize) {
            this.resize();
        }
    }

    private void resize() {
        Shell shell = this.getShell();
        shell.setRedraw(false);
        Point size = shell.computeSize(300, -1);
        shell.setSize(size);
        shell.setLocation(this.getInitialLocation(size));
        shell.layout(true, true);
        shell.setRedraw(true);
    }

    private void createTipSection(Composite parent, final TipInfo info) {
        final IWorkbenchWindow activeWindow = UiPlugin.getActiveWorkbenchWindow();
        String infoText = info.infoText;
        String linkText = info.linkText;
        String bindingText = info.getKeyBindingText(activeWindow);
        SelectionAdapter linkAction = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                info.invokeAction(event.text, activeWindow);
                TipOfTheDayPopup.this.close();
            }
        };
        Label infoLabel = new Label(parent, 64);
        infoLabel.setText(infoText);
        infoLabel.setLayoutData((Object)new GridData(1808));
        this.preferenceLink = new Link(parent, 131136);
        this.preferenceLink.addSelectionListener((SelectionListener)linkAction);
        this.preferenceLink.setText(linkText);
        this.preferenceLink.setLayoutData((Object)new GridData(1808));
        this.preferenceLink.setBackground(parent.getBackground());
        if (bindingText != null) {
            Label bindingLabel = new Label(parent, 64);
            bindingLabel.setText(bindingText);
            bindingLabel.setLayoutData((Object)new GridData(1808));
        }
    }

    private void createDontRemindSection(Composite parent) {
        this.dontRemindButton = new Button(parent, 32);
        this.dontRemindButton.setText("Don't show this again");
        this.dontRemindButton.setSelection(!this.prefs.getBoolean("show.tip"));
        this.dontRemindButton.setLayoutData((Object)new GridData(1808));
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite titleComposite = (Composite)super.createTitleMenuArea(parent);
        ToolBar toolBar = new ToolBar(titleComposite, 0x800000);
        ToolItem closeButton = new ToolItem(toolBar, 8, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        closeButton.setImage(StsUiImages.TIP_CLOSE.createImage());
        closeButton.setHotImage(StsUiImages.TIP_CLOSE_HOT.createImage());
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipOfTheDayPopup.this.close();
            }
        });
        titleComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TipOfTheDayPopup.this.close();
            }
        });
        return titleComposite;
    }

    private Control createNextPrevArea(Composite parent) {
        Composite nextPrevComposite = new Composite(parent, 0);
        nextPrevComposite.setLayoutData((Object)new GridData(1808));
        nextPrevComposite.setLayout((Layout)new GridLayout(3, false));
        Button navButton = new Button(nextPrevComposite, 0x800000);
        navButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        navButton.setImage(StsUiImages.getImage(StsUiImages.TIP_PREV));
        navButton.setToolTipText("Show previous tip");
        navButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipOfTheDayPopup.this.createTip(TipOfTheDayPopup.this.provider.previousTip(), true);
            }
        });
        navButton = new Button(nextPrevComposite, 0x800000);
        navButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        navButton.setImage(StsUiImages.getImage(StsUiImages.TIP_NEXT));
        navButton.setToolTipText("Show next tip");
        navButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipOfTheDayPopup.this.createTip(TipOfTheDayPopup.this.provider.nextTip(), true);
            }
        });
        return nextPrevComposite;
    }

    protected Control createTitleControl(Composite parent) {
        Control control = super.createTitleControl(parent);
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).horizontalSpan = 1;
        }
        return control;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point parentLocation;
        Point parentSize;
        Shell parent = this.getParentShell();
        Rectangle updateRectangle = null;
        if (parent != null) {
            Shell[] shells;
            Shell[] shellArray = shells = parent.getDisplay().getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (shell.getText().equals("Updates Available")) {
                    updateRectangle = shell.getBounds();
                }
                ++n2;
            }
            parentSize = parent.getSize();
            parentLocation = parent.getLocation();
        } else {
            Rectangle bounds = this.getShell().getDisplay().getBounds();
            parentSize = new Point(bounds.width, bounds.height);
            parentLocation = new Point(0, 0);
        }
        if (updateRectangle == null) {
            return new Point(parentSize.x - initialSize.x + parentLocation.x - 20, parentSize.y - initialSize.y + parentLocation.y - 20);
        }
        return new Point(parentSize.x - initialSize.x + parentLocation.x - 20, updateRectangle.y - initialSize.y - 20);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    public boolean close() {
        if (!this.dontRemindButton.isDisposed()) {
            this.prefs.setValue("show.tip", !this.dontRemindButton.getSelection());
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Spring Tool Tips");
    }
}

