/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigFactory;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigSet;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesProject
extends BeansProject {
    public PropertiesProject(PropertiesModel model, IBeansProject project) {
        super((IBeansModel)model, project.getProject());
        this.modelPopulated = true;
        this.configSuffixes = new LinkedHashSet(project.getConfigSuffixes());
        this.locatorByAutoDetectedConfig = new HashMap();
        this.autoDetectedConfigsByLocator = new HashMap();
        this.autoDetectedConfigSets = new HashMap();
        this.autoDetectedConfigSetsByLocator = new HashMap();
        this.isImportsEnabled = project.isImportsEnabled();
        this.configs = new LinkedHashMap();
        this.autoDetectedConfigs = new LinkedHashMap();
        for (IBeansConfig config : project.getConfigs()) {
            if (config.getType() == IBeansConfig.Type.MANUAL) {
                this.configs.put(config.getElementName(), PropertiesConfigFactory.create(this, config.getElementName(), config.getType()));
                continue;
            }
            this.autoDetectedConfigs.put(config.getElementName(), PropertiesConfigFactory.create(this, config.getElementName(), config.getType()));
        }
        this.configSets = new LinkedHashMap();
        for (IBeansConfigSet configSet : project.getConfigSets()) {
            this.configSets.put(configSet.getElementName(), new PropertiesConfigSet(this, configSet, configSet.getType()));
        }
        this.updateAllConfigsCache();
    }

    public void setConfigSuffixes(Set<String> suffixes) {
        super.setConfigSuffixes(suffixes);
    }

    public boolean addConfigSuffix(String suffix) {
        if (super.addConfigSuffix(suffix)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public void setConfigs(Set<String> configNames) {
        super.setConfigs(configNames);
        this.notifyListeners();
    }

    public boolean addConfig(String configName, IBeansConfig.Type type) {
        if (super.addConfig(configName, type)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public boolean removeConfig(String configName) {
        if (super.removeConfig(configName)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public void setConfigSets(Set<IBeansConfigSet> configSets) {
        super.setConfigSets(configSets);
        this.notifyListeners();
    }

    public boolean addConfigSet(IBeansConfigSet configSet) {
        if (super.addConfigSet(configSet)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public void removeConfigSet(String configSetName) {
        super.removeConfigSet(configSetName);
        this.notifyListeners();
    }

    protected final void notifyListeners() {
        PropertiesModel model = (PropertiesModel)this.getElementParent();
        model.notifyListeners((IModelElement)this, ModelChangeEvent.Type.CHANGED);
    }
}

