/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigFactory;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IProfileAwareBeansComponent;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigSet;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSetDialog
extends Dialog {
    private static final String PREFIX = "ConfigSetDialog.";
    private static final String TITLE_NEW = "ConfigSetDialog.title.new";
    private static final String TITLE_EDIT = "ConfigSetDialog.title.edit";
    private static final String ERROR_INVALID_NAME = "ConfigSetDialog.error.invalidName";
    private static final String ERROR_USED_NAME = "ConfigSetDialog.error.usedName";
    private static final String NAME_LABEL = "ConfigSetDialog.name.label";
    private static final String PROFILE_LABEL = "ConfigSetDialog.profiles.label";
    private static final String OVERRIDE_LABEL = "ConfigSetDialog.override.label";
    private static final String INCOMPLETE_LABEL = "ConfigSetDialog.incomplete.label";
    private static final String VIEWER_LABEL = "ConfigSetDialog.viewer.label";
    private static final String SELECT_ALL_LABEL = "ConfigSetDialog.select.all.label";
    private static final String DESELECT_ALL_LABEL = "ConfigSetDialog.deselect.all.label";
    private static final int LIST_VIEWER_WIDTH = 400;
    private static final int LIST_VIEWER_HEIGHT = 250;
    private CLabel messageLabel;
    private Text nameText;
    private Text profilesText;
    private Button overrideButton;
    private Button incompleteButton;
    private CheckboxTableViewer configsViewer;
    private Label errorLabel;
    private Button okButton;
    private PropertiesProject project;
    private PropertiesConfigSet configSet;
    private String title;
    private Mode mode;

    public ConfigSetDialog(Shell parent, PropertiesProject project, String configSetName, IBeansConfigSet.Type type) {
        super(parent);
        this.project = project;
        if (configSetName == null) {
            this.configSet = new PropertiesConfigSet(project, null, type);
            this.title = BeansUIPlugin.getResourceString(TITLE_NEW);
            this.mode = Mode.NEW;
        } else {
            this.configSet = (PropertiesConfigSet)project.getConfigSet(configSetName);
            this.title = BeansUIPlugin.getResourceString(TITLE_EDIT);
            this.mode = Mode.EDIT;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite optionsGroup = new Composite(composite, 0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        this.messageLabel = new CLabel(optionsGroup, 0);
        this.messageLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameText = SpringUIUtils.createTextField((Composite)optionsGroup, (String)BeansUIPlugin.getResourceString(NAME_LABEL), (int)0, (int)0, (int)50);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSetDialog.this.validateName();
            }
        });
        this.profilesText = SpringUIUtils.createTextField((Composite)optionsGroup, (String)BeansUIPlugin.getResourceString(PROFILE_LABEL), (int)0, (int)0, (int)50);
        this.profilesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSetDialog.this.validateProfiles();
            }
        });
        this.profilesText.setText(StringUtils.collectionToDelimitedString((Collection)this.configSet.getProfiles(), (String)", "));
        this.createProfilesContentAssist();
        Label options = new Label(optionsGroup, 64);
        options.setText("Options:");
        options.setLayoutData((Object)new GridData(768));
        this.overrideButton = SpringUIUtils.createCheckBox((Composite)optionsGroup, (String)BeansUIPlugin.getResourceString(OVERRIDE_LABEL));
        this.overrideButton.setSelection(this.configSet.isAllowBeanDefinitionOverriding());
        this.incompleteButton = SpringUIUtils.createCheckBox((Composite)optionsGroup, (String)BeansUIPlugin.getResourceString(INCOMPLETE_LABEL));
        this.incompleteButton.setSelection(this.configSet.isIncomplete());
        Label viewerLabel = new Label(composite, 0);
        GridData gd = new GridData(768);
        viewerLabel.setLayoutData((Object)gd);
        viewerLabel.setText(BeansUIPlugin.getResourceString(VIEWER_LABEL));
        this.configsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 250;
        this.configsViewer.getTable().setLayoutData((Object)gd);
        this.configsViewer.setContentProvider((IContentProvider)new ConfigFilesContentProvider(this.createConfigList()));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new PropertiesModelLabelProvider());
        this.configsViewer.setSorter((ViewerSorter)new ConfigFilesSorter());
        this.configsViewer.setInput((Object)this);
        this.configsViewer.setCheckedElements(this.configSet.getConfigs().toArray());
        this.configsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigSetDialog.this.validateProfiles();
            }
        });
        Composite buttonsGroup = new Composite(composite, 0);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 0;
        layout.marginBottom = 10;
        buttonsGroup.setLayout((Layout)layout);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        SpringUIUtils.createButton((Composite)buttonsGroup, (String)BeansUIPlugin.getResourceString(SELECT_ALL_LABEL), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigSetDialog.this.configsViewer.setAllChecked(true);
            }
        });
        SpringUIUtils.createButton((Composite)buttonsGroup, (String)BeansUIPlugin.getResourceString(DESELECT_ALL_LABEL), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigSetDialog.this.configsViewer.setAllChecked(false);
            }
        });
        this.errorLabel = new Label(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setForeground(JFaceColors.getErrorText((Display)parent.getDisplay()));
        this.errorLabel.setBackground(JFaceColors.getErrorBackground((Display)parent.getDisplay()));
        ConfigSetDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Set<String> getDefinedProfiles(IBeansComponent component, String filter, Set<String> existingProfiles) {
        HashSet<String> profiles = new HashSet<String>();
        if (component instanceof IProfileAwareBeansComponent) {
            Set currentProfiles = ((IProfileAwareBeansComponent)component).getProfiles();
            for (String profile : currentProfiles) {
                if (!profile.startsWith(filter) || existingProfiles.contains(profile)) continue;
                profiles.add(profile);
            }
        }
        Set children = component.getComponents();
        for (IBeansComponent child : children) {
            profiles.addAll(this.getDefinedProfiles(child, filter, existingProfiles));
        }
        return profiles;
    }

    private void createProfilesContentAssist() {
        IContentProposalProvider proposalProvider = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                String prefix;
                String filter = prefix = contents.substring(0, position);
                HashSet<String> existingProfiles = new HashSet<String>();
                int separatorIndex = -1;
                while (filter.contains(",")) {
                    separatorIndex = prefix.indexOf(",");
                    if (separatorIndex < 0) continue;
                    existingProfiles.add(prefix.substring(0, separatorIndex));
                    filter = prefix.substring(separatorIndex + 1);
                    while (filter.startsWith(" ")) {
                        ++separatorIndex;
                        filter = filter.substring(1);
                    }
                }
                Set configs = ConfigSetDialog.this.project.getConfigs();
                HashSet profiles = new HashSet();
                for (IBeansConfig config : configs) {
                    Set components = config.getComponents();
                    for (IBeansComponent component : components) {
                        profiles.addAll(ConfigSetDialog.this.getDefinedProfiles(component, filter, existingProfiles));
                    }
                }
                ArrayList<ProfileContentProposal> proposals = new ArrayList<ProfileContentProposal>();
                for (String profile : profiles) {
                    proposals.add(new ProfileContentProposal(profile, separatorIndex + 1, position));
                }
                Collections.sort(proposals, new Comparator<IContentProposal>(){

                    @Override
                    public int compare(IContentProposal o1, IContentProposal o2) {
                        return o1.getLabel().compareTo(o2.getLabel());
                    }
                });
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }
        };
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.profilesText, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, keyStroke, null);
            contentProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    if (proposal instanceof ProfileContentProposal) {
                        ProfileContentProposal profileProposal = (ProfileContentProposal)proposal;
                        Set configs = ConfigSetDialog.this.getDefiningConfigForProfile(profileProposal.getProfile());
                        for (IBeansConfig config : configs) {
                            if (ConfigSetDialog.this.configsViewer.getChecked((Object)config)) continue;
                            ConfigSetDialog.this.configsViewer.setChecked((Object)config, true);
                        }
                        ConfigSetDialog.this.validateProfiles();
                    }
                }
            });
        }
        catch (ParseException parseException) {}
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        String name = this.configSet.getElementName();
        if (name != null && name.trim().length() != 0) {
            this.nameText.setText(name);
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.mode == Mode.EDIT) {
                this.project.removeConfigSet(this.configSet.getElementName());
            }
            this.configSet.setElementName(this.nameText.getText());
            this.configSet.setAllowBeanDefinitionOverriding(this.overrideButton.getSelection());
            this.configSet.setIncomplete(this.incompleteButton.getSelection());
            LinkedHashSet<String> profiles = new LinkedHashSet<String>();
            if (this.profilesText.getText().length() > 0) {
                String[] profilesSpec;
                String[] stringArray = profilesSpec = StringUtils.tokenizeToStringArray((String)this.profilesText.getText(), (String)",; ");
                int n = profilesSpec.length;
                int n2 = 0;
                while (n2 < n) {
                    String profile = stringArray[n2];
                    profiles.add(profile);
                    ++n2;
                }
            }
            this.configSet.setProfiles(profiles);
            LinkedHashSet<IBeansConfig> oldConfigs = new LinkedHashSet<IBeansConfig>(this.configSet.getConfigs());
            this.configSet.removeAllConfigs();
            List<Object> newConfigs = Arrays.asList(this.configsViewer.getCheckedElements());
            for (IBeansConfig config : oldConfigs) {
                if (!newConfigs.contains(config)) continue;
                this.configSet.addConfig(config.getElementName());
            }
            for (Object newConfig : newConfigs) {
                IBeansConfig config = (IBeansConfig)newConfig;
                String configName = config.getElementName();
                if (this.configSet.hasConfig(configName)) continue;
                this.configSet.addConfig(configName);
            }
            this.project.addConfigSet((IBeansConfigSet)this.configSet);
        }
        super.buttonPressed(buttonId);
    }

    private List<IBeansConfig> createConfigList() {
        ArrayList<IBeansConfig> configs = new ArrayList<IBeansConfig>(this.configSet.getConfigs());
        this.addConfigsFromReferencedProjects((IBeansProject)this.project, configs, new HashSet<IProject>(), false);
        return configs;
    }

    private void addConfigsFromReferencedProjects(IBeansProject beansProject, List<IBeansConfig> configs, Set<IProject> projects, boolean addProjectPath) {
        if (beansProject == null || projects.contains(beansProject.getProject())) {
            return;
        }
        projects.add(beansProject.getProject());
        IBeansModel model = BeansCorePlugin.getModel();
        try {
            for (IBeansConfig config : beansProject.getConfigs()) {
                String name;
                String projectPath = ModelUtils.getResourcePath((IModelElement)config.getElementParent());
                if (projectPath == null) continue;
                String string = name = addProjectPath && config instanceof BeansConfig ? String.valueOf(projectPath) + "/" + config.getElementName() : config.getElementName();
                if (this.configSet.hasConfig(name)) continue;
                configs.add(BeansConfigFactory.create((IBeansProject)beansProject, (String)name, (IBeansConfig.Type)IBeansConfig.Type.MANUAL));
            }
            IProject[] iProjectArray = beansProject.getProject().getProject().getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                IBeansProject referencedProj = model.getProject(proj);
                this.addConfigsFromReferencedProjects(referencedProj, configs, projects, true);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private Set<IBeansConfig> getDefiningConfigForProfile(String profile) {
        Set configs = this.project.getConfigs();
        HashSet<IBeansConfig> definingConfigs = new HashSet<IBeansConfig>();
        block0: for (IBeansConfig config : configs) {
            Set components = config.getComponents();
            for (IBeansComponent component : components) {
                Set<String> existingProfiles;
                if (!this.getDefinedProfiles(component, "", existingProfiles = Collections.emptySet()).contains(profile)) continue;
                definingConfigs.add(config);
                continue block0;
            }
        }
        return definingConfigs;
    }

    private void validateProfiles() {
        if (this.configsViewer != null) {
            String profile;
            String[] profiles = StringUtils.tokenizeToStringArray((String)this.profilesText.getText(), (String)",; ");
            List<Object> configs = Arrays.asList(this.configsViewer.getCheckedElements());
            HashSet<String> unselectedProfiles = new HashSet<String>();
            String[] stringArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                profile = stringArray[n2];
                boolean configSelected = false;
                for (Object obj : configs) {
                    IBeansConfig config = (IBeansConfig)obj;
                    Set components = config.getComponents();
                    for (IBeansComponent component : components) {
                        Set<String> existingProfiles;
                        if (!this.getDefinedProfiles(component, "", existingProfiles = Collections.emptySet()).contains(profile)) continue;
                        configSelected = true;
                    }
                }
                if (!configSelected) {
                    unselectedProfiles.add(profile);
                }
                ++n2;
            }
            if (unselectedProfiles.size() > 0) {
                this.messageLabel.setImage(BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.warning.png"));
                this.messageLabel.setText("Profiles selected (" + StringUtils.arrayToDelimitedString((Object[])unselectedProfiles.toArray(), (String)", ") + ") are not defined in selected config files.");
                return;
            }
            stringArray = profiles;
            n = profiles.length;
            n2 = 0;
            while (n2 < n) {
                profile = stringArray[n2];
                Set<IBeansConfig> definingConfigs = this.getDefiningConfigForProfile(profile);
                for (IBeansConfig definingConfig : definingConfigs) {
                    if (configs.contains(definingConfig)) continue;
                    this.messageLabel.setImage(BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.warning.png"));
                    this.messageLabel.setText("Selected config files do not completely define profiles selected.");
                    return;
                }
                ++n2;
            }
        }
        this.messageLabel.setImage(null);
        if (this.mode == Mode.NEW) {
            this.messageLabel.setText("Create a new config set.");
        } else {
            this.messageLabel.setText("Edit config set.");
        }
    }

    private void validateName() {
        boolean isEnabled = false;
        String name = this.nameText.getText();
        if (name == null || name.trim().length() == 0) {
            this.errorLabel.setText(BeansUIPlugin.getResourceString(ERROR_INVALID_NAME));
        } else if (this.mode == Mode.NEW || !name.equals(this.configSet.getElementName())) {
            if (this.project.hasConfigSet(name)) {
                this.errorLabel.setText(BeansUIPlugin.getResourceString(ERROR_USED_NAME));
            } else {
                this.errorLabel.setText("");
                isEnabled = true;
            }
        } else {
            this.errorLabel.setText("");
            isEnabled = true;
        }
        this.okButton.setEnabled(isEnabled);
        this.errorLabel.getParent().update();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFilesContentProvider
    implements IStructuredContentProvider {
        private List<IBeansConfig> configs;

        public ConfigFilesContentProvider(List<IBeansConfig> configs) {
            this.configs = configs;
        }

        public Object[] getElements(Object obj) {
            return this.configs.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ConfigFilesSorter
    extends ViewerSorter {
        private ConfigFilesSorter() {
        }

        public int category(Object element) {
            if (element instanceof IBeansConfig) {
                if (((IBeansConfig)element).getElementName().indexOf(47) == -1) {
                    return Category.ROOT_DIR.ordinal();
                }
                return Category.SUB_DIR.ordinal();
            }
            return Category.OTHER.ordinal();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Category {
            SUB_DIR,
            ROOT_DIR,
            OTHER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        NEW,
        EDIT;

    }

    private class ProfileContentProposal
    implements IContentProposal {
        private final String profile;
        private final int offset;
        private final int cursorPosition;

        public ProfileContentProposal(String profile, int offset, int cursorPosition) {
            this.profile = profile;
            this.offset = offset;
            this.cursorPosition = cursorPosition;
        }

        public String getLabel() {
            return this.profile;
        }

        public String getDescription() {
            Set configs = ConfigSetDialog.this.getDefiningConfigForProfile(this.profile);
            HashSet<String> configNames = new HashSet<String>();
            for (IBeansConfig config : configs) {
                configNames.add(config.getElementName());
            }
            return "Profile \"" + this.profile + "\" defined in " + StringUtils.collectionToDelimitedString(configNames, (String)", ");
        }

        public int getCursorPosition() {
            return this.offset + this.profile.length();
        }

        public String getContent() {
            return this.profile.substring(this.cursorPosition - this.offset, this.profile.length());
        }

        public String getProfile() {
            return this.profile;
        }
    }
}

