/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeansNavigatorSorter
extends ViewerSorter {
    public int category(Object element) {
        if (element instanceof IBeansConfigSet) {
            return 1;
        }
        if (element instanceof BeanMetadataReference) {
            return 2;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (SpringUIUtils.isSortingEnabled() && SpringUIUtils.isSpringExplorer((Viewer)viewer)) {
            if (e1 instanceof IFile && e2 instanceof IFile) {
                String f1 = this.getFileLabel((IFile)e1);
                String f2 = this.getFileLabel((IFile)e2);
                return super.compare(viewer, (Object)f1, (Object)f2);
            }
            return super.compare(viewer, e1, e2);
        }
        if (e1 instanceof BeanMetadataNode && e2 instanceof BeanMetadataNode) {
            int first = ((BeanMetadataNode)e1).getLocation().getStartLine();
            int second = ((BeanMetadataNode)e2).getLocation().getStartLine();
            return Integer.valueOf(first).compareTo(second);
        }
        if (e1 instanceof ISourceModelElement && e2 instanceof ISourceModelElement) {
            int first = ((ISourceModelElement)e1).getElementStartLine();
            int second = ((ISourceModelElement)e2).getElementStartLine();
            return Integer.valueOf(first).compareTo(second);
        }
        return 0;
    }

    private String getFileLabel(IFile file) {
        return String.valueOf(file.getName()) + " - " + file.getProjectRelativePath().removeLastSegments(1).toString();
    }
}

