/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model.metadata;

import java.util.HashSet;
import java.util.Set;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetadataReference {
    private final Set<Object> beanMetaData;
    private String key;
    protected final IBeansProject beansProject;

    public BeanMetadataReference(IBeansProject project, Set<Object> beanMetaData, String key) {
        this.beansProject = project;
        this.beanMetaData = beanMetaData;
        this.key = key;
    }

    public BeanMetadataReference(IBeansProject project, String key) {
        this(project, new HashSet<Object>(), key);
    }

    public void addChild(Object metadata) {
        this.beanMetaData.add(metadata);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanMetadataReference)) {
            return false;
        }
        BeanMetadataReference that = (BeanMetadataReference)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.beansProject, (Object)that.beansProject);
    }

    public Object firstChild() {
        if (this.beanMetaData.size() > 0) {
            return this.beanMetaData.iterator().next();
        }
        return null;
    }

    public IBeansProject getBeansProject() {
        return this.beansProject;
    }

    public Object[] getChildren() {
        return this.beanMetaData.toArray();
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.beansProject);
        return 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.key);
    }
}

