/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CounterPanel
extends Composite {
    protected Text fNumberOfErrors;
    protected Text fNumberOfRuns;
    private final Image fErrorIcon = BambooImages.getImageDescriptor("ovr16/error_ovr.gif").createImage();

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel("Total:", null, " 0 ");
        this.fNumberOfErrors = this.createLabel("Errors:", this.fErrorIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        value.setBackground(this.getDisplay().getSystemColor(22));
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setRunValue(0);
    }

    public void setRunValue(int value) {
        this.fNumberOfRuns.setText(Integer.toString(value));
        this.redraw();
    }

    public void setErrorValue(int value) {
        this.fNumberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }
}

