/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.servlet.internal;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.proxy.ProxyServlet;

public class CrossOriginProxyServlet
extends ProxyServlet {
    private static final long serialVersionUID = 1L;
    private String urlParameterName;

    public CrossOriginProxyServlet(String urlParameterName) {
        this.urlParameterName = urlParameterName;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        String proxyTo = this.getProxyTo(request);
        if (proxyTo != null) {
            return URI.create(proxyTo).normalize();
        }
        return null;
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
        HttpFields headers = proxyRequest.getHeaders();
        headers.remove("Host");
        HttpURI url = new HttpURI(proxyRequest.getURI());
        headers.add("Host", url.getHost());
    }

    private String getProxyTo(HttpServletRequest request) {
        return request.getParameter(this.urlParameterName);
    }
}

